/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import io.swagger.annotations.ApiModel;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * The review status of the current display name request. See also [Get Display Name Status](https://developers.facebook.com/docs/whatsapp/business-management-api/manage-phone-numbers#get-display-name-status--beta-). - &#x60;APPROVED&#x60;: The name has been approved. You can download your certificate now. - &#x60;AVAILABLE_WITHOUT_REVIEW&#x60;: The certificate for the phone is available and display name is ready to use without review. - &#x60;DECLINED&#x60;: The name has not been approved. You cannot download your certificate. - &#x60;EXPIRED&#x60;: Your certificate has expire and can no longer be downloaded. - &#x60;PENDING_REVIEW&#x60;: Your name request is under review. You cannot download your certificate. - &#x60;NONE&#x60;: No certificate is available.
 */
@JsonAdapter(WhatsappPhoneNumberNameStatus.Adapter.class)
public enum WhatsappPhoneNumberNameStatus {
  
  APPROVED("APPROVED"),
  
  AVAILABLE_WITHOUT_REVIEW("AVAILABLE_WITHOUT_REVIEW"),
  
  DECLINED("DECLINED"),
  
  EXPIRED("EXPIRED"),
  
  PENDING_REVIEW("PENDING_REVIEW"),
  
  NONE("NONE");

  private String value;

  WhatsappPhoneNumberNameStatus(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static WhatsappPhoneNumberNameStatus fromValue(String value) {
    for (WhatsappPhoneNumberNameStatus b : WhatsappPhoneNumberNameStatus.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<WhatsappPhoneNumberNameStatus> {
    @Override
    public void write(final JsonWriter jsonWriter, final WhatsappPhoneNumberNameStatus enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public WhatsappPhoneNumberNameStatus read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return WhatsappPhoneNumberNameStatus.fromValue(value);
    }
  }
}

