/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import io.swagger.annotations.ApiModel;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * Indicates the update event type of WhatsApp phone number quality when a notification is sent to you. - &#x60;ONBOARDING&#x60;: Typically when the messaging limit changes from &#x60;TIER_NOT_SET&#x60; to another tier.  - &#x60;UPGRADE&#x60;: Messaging limit tier upgraded. - &#x60;DOWNGRADE&#x60;: Messaging limit tier downgraded. - &#x60;FLAGGED&#x60;: Flagged status occurs when the quality rating reaches a low state. If the message quality improves to a high or medium state and maintains this for 7 days, your status will return to Connected. If the quality rating doesn&#39;t improve, your status will still return to Connected, but you&#39;ll be placed in a lower messaging limit tier. Learn more on [Phone Number Quality Rating](https://www.facebook.com/business/help/896873687365001) docs. - &#x60;UNFLAGGED&#x60;: Phone number status changes from &#x60;FLAGGED&#x60; to &#x60;CONNECTED&#x60;.
 */
@JsonAdapter(WhatsappPhoneNumberQualityUpdateEventEnum.Adapter.class)
public enum WhatsappPhoneNumberQualityUpdateEventEnum {
  
  ONBOARDING("ONBOARDING"),
  
  UPGRADE("UPGRADE"),
  
  DOWNGRADE("DOWNGRADE"),
  
  FLAGGED("FLAGGED"),
  
  UNFLAGGED("UNFLAGGED");

  private String value;

  WhatsappPhoneNumberQualityUpdateEventEnum(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static WhatsappPhoneNumberQualityUpdateEventEnum fromValue(String value) {
    for (WhatsappPhoneNumberQualityUpdateEventEnum b : WhatsappPhoneNumberQualityUpdateEventEnum.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<WhatsappPhoneNumberQualityUpdateEventEnum> {
    @Override
    public void write(final JsonWriter jsonWriter, final WhatsappPhoneNumberQualityUpdateEventEnum enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public WhatsappPhoneNumberQualityUpdateEventEnum read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return WhatsappPhoneNumberQualityUpdateEventEnum.fromValue(value);
    }
  }
}

