/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import io.swagger.annotations.ApiModel;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * The status of a WhatsApp business phone number. - &#x60;PENDING&#x60;: Pending. Phone number is newly added. Verify and register this phone number so it can be connected to your account. - &#x60;UNVERIFIED&#x60;: Unverified. Verify this phone number to start sending messages. - &#x60;MANUAL_REVIEW&#x60;: Being reviewed. Phone number is currently being reviewed for connection to your account. - &#x60;DISCONNECTED&#x60;: Offline. Phone number is currently not reachable by WhatsApp servers. - &#x60;CONNECTED&#x60;: Connected. Phone number is associated with this account and working properly. - &#x60;FLAGGED&#x60;: Flagged. This phone number has been flagged due to low quality messages. - &#x60;WARNED&#x60;: Warned. A warning has been issued for this number, potentially due to spam reports. - &#x60;RATE_LIMITED&#x60;: Rate limited. The number of messages you can send from this phone number may be restricted. - &#x60;BANNED&#x60;: Banned. Phone number cannot be used with a WhatsApp account. - &#x60;RESTRICTED&#x60;: Restricted. This phone number has reached its 24-hour messaging limit and can no longer send messages to customers. Please wait until the messaging limit is reset to send messages. - &#x60;BLOCKED&#x60;: Message limit reached. The limit has been reached for this 24-hour period. - &#x60;MIGRATED&#x60;: Transferred. This phone number has been transferred to another WhatsApp Business account. - &#x60;UNKNOWN&#x60;: Unavailable. The status of this phone number can&#39;t be determined right now.
 */
@JsonAdapter(WhatsappPhoneNumberStatus.Adapter.class)
public enum WhatsappPhoneNumberStatus {
  
  PENDING("PENDING"),
  
  UNVERIFIED("UNVERIFIED"),
  
  MANUAL_REVIEW("MANUAL_REVIEW"),
  
  DISCONNECTED("DISCONNECTED"),
  
  CONNECTED("CONNECTED"),
  
  FLAGGED("FLAGGED"),
  
  WARNED("WARNED"),
  
  RATE_LIMITED("RATE_LIMITED"),
  
  BANNED("BANNED"),
  
  RESTRICTED("RESTRICTED"),
  
  BLOCKED("BLOCKED"),
  
  MIGRATED("MIGRATED"),
  
  UNKNOWN("UNKNOWN");

  private String value;

  WhatsappPhoneNumberStatus(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static WhatsappPhoneNumberStatus fromValue(String value) {
    for (WhatsappPhoneNumberStatus b : WhatsappPhoneNumberStatus.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<WhatsappPhoneNumberStatus> {
    @Override
    public void write(final JsonWriter jsonWriter, final WhatsappPhoneNumberStatus enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public WhatsappPhoneNumberStatus read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return WhatsappPhoneNumberStatus.fromValue(value);
    }
  }
}

