/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import io.swagger.annotations.ApiModel;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * Category of WhatsApp templates. - &#x60;AUTHENTICATION&#x60;: Enable businesses to authenticate users with one-time passcodes, potentially at multiple steps in the login process (e.g., account verification, account recovery, integrity challenges). - &#x60;MARKETING&#x60;: Include promotions or offers, informational updates, or invitations for customers to respond / take action. Any conversation that does not qualify as utility or authentication is a marketing conversation. - &#x60;UTILITY&#x60;: Facilitate a specific, agreed-upon request or transaction or update to a customer about an ongoing transaction, including post-purchase notifications and recurring billing statements.
 */
@JsonAdapter(WhatsappTemplateCategory.Adapter.class)
public enum WhatsappTemplateCategory {
  
  AUTHENTICATION("AUTHENTICATION"),
  
  MARKETING("MARKETING"),
  
  UTILITY("UTILITY");

  private String value;

  WhatsappTemplateCategory(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static WhatsappTemplateCategory fromValue(String value) {
    for (WhatsappTemplateCategory b : WhatsappTemplateCategory.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<WhatsappTemplateCategory> {
    @Override
    public void write(final JsonWriter jsonWriter, final WhatsappTemplateCategory enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public WhatsappTemplateCategory read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return WhatsappTemplateCategory.fromValue(value);
    }
  }
}

