/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.model.WhatsappTemplateComponentButton;
import com.ycloud.client.model.WhatsappTemplateComponentCard;
import com.ycloud.client.model.WhatsappTemplateComponentExample;
import com.ycloud.client.model.WhatsappTemplateComponentLimitedTimeOffer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.ycloud.client.JSON;

/**
 * WhatsappTemplateComponent
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class WhatsappTemplateComponent {
  /**
   * **Required.** Template component type. - &#x60;BODY&#x60;: Body components are text-only components and are required by all templates. Templates are limited to one body component. - &#x60;HEADER&#x60;: Headers are optional components that appear at the top of template messages. Headers support text, media (images, videos, documents). Templates are limited to one header component. - &#x60;FOOTER&#x60;: Footers are optional text-only components that appear immediately after the body component. Templates are limited to one footer component. - &#x60;BUTTONS&#x60;: Buttons are optional interactive components that perform specific actions when tapped. - &#x60;LIMITED_TIME_OFFER&#x60;: Use for limited-time offer templates. The delivered message can display an offer expiration details section with a heading, an optional expiration timer, and the offer code itself. - &#x60;CAROUSEL&#x60;: Carousel templates allow you to send a single text message (1), accompanied by a set of up to 10 carousel cards (2) in a horizontally scrollable view.
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    BODY("BODY"),
    
    HEADER("HEADER"),
    
    FOOTER("FOOTER"),
    
    BUTTONS("BUTTONS"),
    
    LIMITED_TIME_OFFER("LIMITED_TIME_OFFER"),
    
    CAROUSEL("CAROUSEL");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return TypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_TYPE = "type";
  /**
   * **Required.** Template component type. - &#x60;BODY&#x60;: Body components are text-only components and are required by all templates. Templates are limited to one body component. - &#x60;HEADER&#x60;: Headers are optional components that appear at the top of template messages. Headers support text, media (images, videos, documents). Templates are limited to one header component. - &#x60;FOOTER&#x60;: Footers are optional text-only components that appear immediately after the body component. Templates are limited to one footer component. - &#x60;BUTTONS&#x60;: Buttons are optional interactive components that perform specific actions when tapped. - &#x60;LIMITED_TIME_OFFER&#x60;: Use for limited-time offer templates. The delivered message can display an offer expiration details section with a heading, an optional expiration timer, and the offer code itself. - &#x60;CAROUSEL&#x60;: Carousel templates allow you to send a single text message (1), accompanied by a set of up to 10 carousel cards (2) in a horizontally scrollable view.
  **/
  @SerializedName(SERIALIZED_NAME_TYPE)
  private TypeEnum type;

  /**
   * **Required for type &#x60;HEADER&#x60;.**
   */
  @JsonAdapter(FormatEnum.Adapter.class)
  public enum FormatEnum {
    TEXT("TEXT"),
    
    IMAGE("IMAGE"),
    
    VIDEO("VIDEO"),
    
    DOCUMENT("DOCUMENT");

    private String value;

    FormatEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static FormatEnum fromValue(String value) {
      for (FormatEnum b : FormatEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<FormatEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final FormatEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public FormatEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return FormatEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_FORMAT = "format";
  /**
   * **Required for type &#x60;HEADER&#x60;.**
  **/
  @SerializedName(SERIALIZED_NAME_FORMAT)
  private FormatEnum format;

  public static final String SERIALIZED_NAME_TEXT = "text";
  /**
   * For body text (type &#x3D; &#x60;BODY&#x60;), maximum 1024 characters. For header text (type &#x3D; &#x60;HEADER&#x60;, format &#x3D; &#x60;TEXT&#x60;), maximum 60 characters. For footer text (type &#x3D; &#x60;FOOTER&#x60;), maximum 60 characters. For card body text (&#x60;CAROUSEL&#x60; card component type &#x3D; &#x60;BODY&#x60;), maximum 160 characters.
  **/
  @SerializedName(SERIALIZED_NAME_TEXT)
  private String text;

  public static final String SERIALIZED_NAME_BUTTONS = "buttons";
  /**
   * **Required for type &#x60;BUTTONS&#x60;.** Buttons are optional interactive components that perform specific actions when tapped. Templates can have a mixture of up to 10 button components total, although there are limits to individual buttons of the same type as well as combination limits. If a template has more than three buttons, two buttons will appear in the delivered message and the remaining buttons will be replaced with a **See all options** button. Tapping the **See all options** button reveals the remaining buttons.
  **/
  @SerializedName(SERIALIZED_NAME_BUTTONS)
  private List<WhatsappTemplateComponentButton> buttons = null;

  public static final String SERIALIZED_NAME_ADD_SECURITY_RECOMMENDATION = "add_security_recommendation";
  /**
   * **Optional. Only applicable in the &#x60;BODY&#x60; component of an AUTHENTICATION template.** Set to &#x60;true&#x60; if you want the template to include the string, *For your security, do not share this code.* Set to &#x60;false&#x60; to exclude the string.
  **/
  @SerializedName(SERIALIZED_NAME_ADD_SECURITY_RECOMMENDATION)
  private Boolean addSecurityRecommendation;

  public static final String SERIALIZED_NAME_CODE_EXPIRATION_MINUTES = "code_expiration_minutes";
  /**
   * **Optional. Only applicable in the &#x60;FOOTER&#x60; component of an AUTHENTICATION template.** Indicates number of minutes the password or code is valid. If omitted, the code expiration warning will not be displayed in the delivered message. Minimum 1, maximum 90.
  **/
  @SerializedName(SERIALIZED_NAME_CODE_EXPIRATION_MINUTES)
  private Integer codeExpirationMinutes;

  public static final String SERIALIZED_NAME_LIMITED_TIME_OFFER = "limited_time_offer";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_LIMITED_TIME_OFFER)
  private WhatsappTemplateComponentLimitedTimeOffer limitedTimeOffer;

  public static final String SERIALIZED_NAME_EXAMPLE = "example";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_EXAMPLE)
  private WhatsappTemplateComponentExample example;

  public static final String SERIALIZED_NAME_CARDS = "cards";
  /**
   * **Required for type &#x60;CAROUSEL&#x60;.** Carousel templates support up to 10 carousel cards.
  **/
  @SerializedName(SERIALIZED_NAME_CARDS)
  private List<WhatsappTemplateComponentCard> cards = null;

  public WhatsappTemplateComponent() { 
  }

  public WhatsappTemplateComponent type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * **Required.** Template component type. - &#x60;BODY&#x60;: Body components are text-only components and are required by all templates. Templates are limited to one body component. - &#x60;HEADER&#x60;: Headers are optional components that appear at the top of template messages. Headers support text, media (images, videos, documents). Templates are limited to one header component. - &#x60;FOOTER&#x60;: Footers are optional text-only components that appear immediately after the body component. Templates are limited to one footer component. - &#x60;BUTTONS&#x60;: Buttons are optional interactive components that perform specific actions when tapped. - &#x60;LIMITED_TIME_OFFER&#x60;: Use for limited-time offer templates. The delivered message can display an offer expiration details section with a heading, an optional expiration timer, and the offer code itself. - &#x60;CAROUSEL&#x60;: Carousel templates allow you to send a single text message (1), accompanied by a set of up to 10 carousel cards (2) in a horizontally scrollable view.
   * @return type
  **/
  @javax.annotation.Nullable

  public TypeEnum getType() {
    return type;
  }


  /**
   * **Required.** Template component type. - &#x60;BODY&#x60;: Body components are text-only components and are required by all templates. Templates are limited to one body component. - &#x60;HEADER&#x60;: Headers are optional components that appear at the top of template messages. Headers support text, media (images, videos, documents). Templates are limited to one header component. - &#x60;FOOTER&#x60;: Footers are optional text-only components that appear immediately after the body component. Templates are limited to one footer component. - &#x60;BUTTONS&#x60;: Buttons are optional interactive components that perform specific actions when tapped. - &#x60;LIMITED_TIME_OFFER&#x60;: Use for limited-time offer templates. The delivered message can display an offer expiration details section with a heading, an optional expiration timer, and the offer code itself. - &#x60;CAROUSEL&#x60;: Carousel templates allow you to send a single text message (1), accompanied by a set of up to 10 carousel cards (2) in a horizontally scrollable view.
   **/
  @ApiModelProperty(value = "**Required.** Template component type. - `BODY`: Body components are text-only components and are required by all templates. Templates are limited to one body component. - `HEADER`: Headers are optional components that appear at the top of template messages. Headers support text, media (images, videos, documents). Templates are limited to one header component. - `FOOTER`: Footers are optional text-only components that appear immediately after the body component. Templates are limited to one footer component. - `BUTTONS`: Buttons are optional interactive components that perform specific actions when tapped. - `LIMITED_TIME_OFFER`: Use for limited-time offer templates. The delivered message can display an offer expiration details section with a heading, an optional expiration timer, and the offer code itself. - `CAROUSEL`: Carousel templates allow you to send a single text message (1), accompanied by a set of up to 10 carousel cards (2) in a horizontally scrollable view.")
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public WhatsappTemplateComponent format(FormatEnum format) {
    
    this.format = format;
    return this;
  }

   /**
   * **Required for type &#x60;HEADER&#x60;.**
   * @return format
  **/
  @javax.annotation.Nullable

  public FormatEnum getFormat() {
    return format;
  }


  /**
   * **Required for type &#x60;HEADER&#x60;.**
   **/
  @ApiModelProperty(value = "**Required for type `HEADER`.**")
  public void setFormat(FormatEnum format) {
    this.format = format;
  }


  public WhatsappTemplateComponent text(String text) {
    
    this.text = text;
    return this;
  }

   /**
   * For body text (type &#x3D; &#x60;BODY&#x60;), maximum 1024 characters. For header text (type &#x3D; &#x60;HEADER&#x60;, format &#x3D; &#x60;TEXT&#x60;), maximum 60 characters. For footer text (type &#x3D; &#x60;FOOTER&#x60;), maximum 60 characters. For card body text (&#x60;CAROUSEL&#x60; card component type &#x3D; &#x60;BODY&#x60;), maximum 160 characters.
   * @return text
  **/
  @javax.annotation.Nullable

  public String getText() {
    return text;
  }


  /**
   * For body text (type &#x3D; &#x60;BODY&#x60;), maximum 1024 characters. For header text (type &#x3D; &#x60;HEADER&#x60;, format &#x3D; &#x60;TEXT&#x60;), maximum 60 characters. For footer text (type &#x3D; &#x60;FOOTER&#x60;), maximum 60 characters. For card body text (&#x60;CAROUSEL&#x60; card component type &#x3D; &#x60;BODY&#x60;), maximum 160 characters.
   **/
  @ApiModelProperty(value = "For body text (type = `BODY`), maximum 1024 characters. For header text (type = `HEADER`, format = `TEXT`), maximum 60 characters. For footer text (type = `FOOTER`), maximum 60 characters. For card body text (`CAROUSEL` card component type = `BODY`), maximum 160 characters.")
  public void setText(String text) {
    this.text = text;
  }


  public WhatsappTemplateComponent buttons(List<WhatsappTemplateComponentButton> buttons) {
    
    this.buttons = buttons;
    return this;
  }

  public WhatsappTemplateComponent addButtonsItem(WhatsappTemplateComponentButton buttonsItem) {
    if (this.buttons == null) {
      this.buttons = new ArrayList<>();
    }
    this.buttons.add(buttonsItem);
    return this;
  }

   /**
   * **Required for type &#x60;BUTTONS&#x60;.** Buttons are optional interactive components that perform specific actions when tapped. Templates can have a mixture of up to 10 button components total, although there are limits to individual buttons of the same type as well as combination limits. If a template has more than three buttons, two buttons will appear in the delivered message and the remaining buttons will be replaced with a **See all options** button. Tapping the **See all options** button reveals the remaining buttons.
   * @return buttons
  **/
  @javax.annotation.Nullable

  public List<WhatsappTemplateComponentButton> getButtons() {
    return buttons;
  }


  /**
   * **Required for type &#x60;BUTTONS&#x60;.** Buttons are optional interactive components that perform specific actions when tapped. Templates can have a mixture of up to 10 button components total, although there are limits to individual buttons of the same type as well as combination limits. If a template has more than three buttons, two buttons will appear in the delivered message and the remaining buttons will be replaced with a **See all options** button. Tapping the **See all options** button reveals the remaining buttons.
   **/
  @ApiModelProperty(value = "**Required for type `BUTTONS`.** Buttons are optional interactive components that perform specific actions when tapped. Templates can have a mixture of up to 10 button components total, although there are limits to individual buttons of the same type as well as combination limits. If a template has more than three buttons, two buttons will appear in the delivered message and the remaining buttons will be replaced with a **See all options** button. Tapping the **See all options** button reveals the remaining buttons.")
  public void setButtons(List<WhatsappTemplateComponentButton> buttons) {
    this.buttons = buttons;
  }


  public WhatsappTemplateComponent addSecurityRecommendation(Boolean addSecurityRecommendation) {
    
    this.addSecurityRecommendation = addSecurityRecommendation;
    return this;
  }

   /**
   * **Optional. Only applicable in the &#x60;BODY&#x60; component of an AUTHENTICATION template.** Set to &#x60;true&#x60; if you want the template to include the string, *For your security, do not share this code.* Set to &#x60;false&#x60; to exclude the string.
   * @return addSecurityRecommendation
  **/
  @javax.annotation.Nullable

  public Boolean getAddSecurityRecommendation() {
    return addSecurityRecommendation;
  }


  /**
   * **Optional. Only applicable in the &#x60;BODY&#x60; component of an AUTHENTICATION template.** Set to &#x60;true&#x60; if you want the template to include the string, *For your security, do not share this code.* Set to &#x60;false&#x60; to exclude the string.
   **/
  @ApiModelProperty(value = "**Optional. Only applicable in the `BODY` component of an AUTHENTICATION template.** Set to `true` if you want the template to include the string, *For your security, do not share this code.* Set to `false` to exclude the string.")
  public void setAddSecurityRecommendation(Boolean addSecurityRecommendation) {
    this.addSecurityRecommendation = addSecurityRecommendation;
  }


  public WhatsappTemplateComponent codeExpirationMinutes(Integer codeExpirationMinutes) {
    
    this.codeExpirationMinutes = codeExpirationMinutes;
    return this;
  }

   /**
   * **Optional. Only applicable in the &#x60;FOOTER&#x60; component of an AUTHENTICATION template.** Indicates number of minutes the password or code is valid. If omitted, the code expiration warning will not be displayed in the delivered message. Minimum 1, maximum 90.
   * minimum: 1
   * maximum: 90
   * @return codeExpirationMinutes
  **/
  @javax.annotation.Nullable

  public Integer getCodeExpirationMinutes() {
    return codeExpirationMinutes;
  }


  /**
   * **Optional. Only applicable in the &#x60;FOOTER&#x60; component of an AUTHENTICATION template.** Indicates number of minutes the password or code is valid. If omitted, the code expiration warning will not be displayed in the delivered message. Minimum 1, maximum 90.
   **/
  @ApiModelProperty(example = "5", value = "**Optional. Only applicable in the `FOOTER` component of an AUTHENTICATION template.** Indicates number of minutes the password or code is valid. If omitted, the code expiration warning will not be displayed in the delivered message. Minimum 1, maximum 90.")
  public void setCodeExpirationMinutes(Integer codeExpirationMinutes) {
    this.codeExpirationMinutes = codeExpirationMinutes;
  }


  public WhatsappTemplateComponent limitedTimeOffer(WhatsappTemplateComponentLimitedTimeOffer limitedTimeOffer) {
    
    this.limitedTimeOffer = limitedTimeOffer;
    return this;
  }

   /**
   * Get limitedTimeOffer
   * @return limitedTimeOffer
  **/
  @javax.annotation.Nullable

  public WhatsappTemplateComponentLimitedTimeOffer getLimitedTimeOffer() {
    return limitedTimeOffer;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setLimitedTimeOffer(WhatsappTemplateComponentLimitedTimeOffer limitedTimeOffer) {
    this.limitedTimeOffer = limitedTimeOffer;
  }


  public WhatsappTemplateComponent example(WhatsappTemplateComponentExample example) {
    
    this.example = example;
    return this;
  }

   /**
   * Get example
   * @return example
  **/
  @javax.annotation.Nullable

  public WhatsappTemplateComponentExample getExample() {
    return example;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setExample(WhatsappTemplateComponentExample example) {
    this.example = example;
  }


  public WhatsappTemplateComponent cards(List<WhatsappTemplateComponentCard> cards) {
    
    this.cards = cards;
    return this;
  }

  public WhatsappTemplateComponent addCardsItem(WhatsappTemplateComponentCard cardsItem) {
    if (this.cards == null) {
      this.cards = new ArrayList<>();
    }
    this.cards.add(cardsItem);
    return this;
  }

   /**
   * **Required for type &#x60;CAROUSEL&#x60;.** Carousel templates support up to 10 carousel cards.
   * @return cards
  **/
  @javax.annotation.Nullable

  public List<WhatsappTemplateComponentCard> getCards() {
    return cards;
  }


  /**
   * **Required for type &#x60;CAROUSEL&#x60;.** Carousel templates support up to 10 carousel cards.
   **/
  @ApiModelProperty(value = "**Required for type `CAROUSEL`.** Carousel templates support up to 10 carousel cards.")
  public void setCards(List<WhatsappTemplateComponentCard> cards) {
    this.cards = cards;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   */
  public WhatsappTemplateComponent putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsappTemplateComponent whatsappTemplateComponent = (WhatsappTemplateComponent) o;
    return Objects.equals(this.type, whatsappTemplateComponent.type) &&
        Objects.equals(this.format, whatsappTemplateComponent.format) &&
        Objects.equals(this.text, whatsappTemplateComponent.text) &&
        Objects.equals(this.buttons, whatsappTemplateComponent.buttons) &&
        Objects.equals(this.addSecurityRecommendation, whatsappTemplateComponent.addSecurityRecommendation) &&
        Objects.equals(this.codeExpirationMinutes, whatsappTemplateComponent.codeExpirationMinutes) &&
        Objects.equals(this.limitedTimeOffer, whatsappTemplateComponent.limitedTimeOffer) &&
        Objects.equals(this.example, whatsappTemplateComponent.example) &&
        Objects.equals(this.cards, whatsappTemplateComponent.cards)&&
        Objects.equals(this.additionalProperties, whatsappTemplateComponent.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, format, text, buttons, addSecurityRecommendation, codeExpirationMinutes, limitedTimeOffer, example, cards, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsappTemplateComponent {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    format: ").append(toIndentedString(format)).append("\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("    buttons: ").append(toIndentedString(buttons)).append("\n");
    sb.append("    addSecurityRecommendation: ").append(toIndentedString(addSecurityRecommendation)).append("\n");
    sb.append("    codeExpirationMinutes: ").append(toIndentedString(codeExpirationMinutes)).append("\n");
    sb.append("    limitedTimeOffer: ").append(toIndentedString(limitedTimeOffer)).append("\n");
    sb.append("    example: ").append(toIndentedString(example)).append("\n");
    sb.append("    cards: ").append(toIndentedString(cards)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("type");
    openapiFields.add("format");
    openapiFields.add("text");
    openapiFields.add("buttons");
    openapiFields.add("add_security_recommendation");
    openapiFields.add("code_expiration_minutes");
    openapiFields.add("limited_time_offer");
    openapiFields.add("example");
    openapiFields.add("cards");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to WhatsappTemplateComponent
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (WhatsappTemplateComponent.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappTemplateComponent is not found in the empty JSON string", WhatsappTemplateComponent.openapiRequiredFields.toString()));
        }
      }
      if (jsonObj.get("type") != null && !jsonObj.get("type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("type").toString()));
      }
      if (jsonObj.get("format") != null && !jsonObj.get("format").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `format` to be a primitive type in the JSON string but got `%s`", jsonObj.get("format").toString()));
      }
      if (jsonObj.get("text") != null && !jsonObj.get("text").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `text` to be a primitive type in the JSON string but got `%s`", jsonObj.get("text").toString()));
      }
      JsonArray jsonArraybuttons = jsonObj.getAsJsonArray("buttons");
      if (jsonArraybuttons != null) {
        // ensure the json data is an array
        if (!jsonObj.get("buttons").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `buttons` to be an array in the JSON string but got `%s`", jsonObj.get("buttons").toString()));
        }

        // validate the optional field `buttons` (array)
        for (int i = 0; i < jsonArraybuttons.size(); i++) {
          WhatsappTemplateComponentButton.validateJsonObject(jsonArraybuttons.get(i).getAsJsonObject());
        };
      }
      // validate the optional field `limited_time_offer`
      if (jsonObj.getAsJsonObject("limited_time_offer") != null) {
        WhatsappTemplateComponentLimitedTimeOffer.validateJsonObject(jsonObj.getAsJsonObject("limited_time_offer"));
      }
      // validate the optional field `example`
      if (jsonObj.getAsJsonObject("example") != null) {
        WhatsappTemplateComponentExample.validateJsonObject(jsonObj.getAsJsonObject("example"));
      }
      JsonArray jsonArraycards = jsonObj.getAsJsonArray("cards");
      if (jsonArraycards != null) {
        // ensure the json data is an array
        if (!jsonObj.get("cards").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `cards` to be an array in the JSON string but got `%s`", jsonObj.get("cards").toString()));
        }

        // validate the optional field `cards` (array)
        for (int i = 0; i < jsonArraycards.size(); i++) {
          WhatsappTemplateComponentCard.validateJsonObject(jsonArraycards.get(i).getAsJsonObject());
        };
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!WhatsappTemplateComponent.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'WhatsappTemplateComponent' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<WhatsappTemplateComponent> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(WhatsappTemplateComponent.class));

       return (TypeAdapter<T>) new TypeAdapter<WhatsappTemplateComponent>() {
           @Override
           public void write(JsonWriter out, WhatsappTemplateComponent value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additonal properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public WhatsappTemplateComponent read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             // store additional fields in the deserialized instance
             WhatsappTemplateComponent instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else { // non-primitive type
                   instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of WhatsappTemplateComponent given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of WhatsappTemplateComponent
  * @throws IOException if the JSON string is invalid with respect to WhatsappTemplateComponent
  */
  public static WhatsappTemplateComponent fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, WhatsappTemplateComponent.class);
  }

 /**
  * Convert an instance of WhatsappTemplateComponent to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

