/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import io.swagger.annotations.ApiModel;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * Button type. - &#x60;PHONE_NUMBER&#x60;: Phone number buttons call the specified business phone number when tapped by the app user. Templates are limited to one phone number button. - &#x60;URL&#x60;: URL buttons load the specified URL in the device&#39;s default web browser when tapped by the app user. Templates are limited to two URL buttons. - &#x60;QUICK_REPLY&#x60;: Quick reply buttons are custom text-only buttons that immediately message you with the specified text string when tapped by the app user. Templates are limited to 10 quick reply buttons. If using quick reply buttons with other buttons, buttons must be organized into two groups: quick reply buttons and non-quick reply buttons. - &#x60;COPY_CODE&#x60;: Copy code buttons copy a text string (defined when the template is sent in a template message) to the device&#39;s clipboard when tapped by the app user. Templates are limited to one copy code button. - &#x60;OTP&#x60;: One-time password (OTP) buttons are a special type of URL button component used with authentication templates. - &#x60;CATALOG&#x60;: When a customer taps the **View catalog** button in a catalog template message, your product catalog appears within WhatsApp. - &#x60;MPM&#x60;: Customers can browse products and sections by tapping the **View items** button in a multi-product template message. - &#x60;FLOW&#x60;: Use this type to specify the [Flow](https://developers.facebook.com/docs/whatsapp/flows) to be sent with the template message.
 */
@JsonAdapter(WhatsappTemplateComponentButtonType.Adapter.class)
public enum WhatsappTemplateComponentButtonType {
  
  PHONE_NUMBER("PHONE_NUMBER"),
  
  URL("URL"),
  
  QUICK_REPLY("QUICK_REPLY"),
  
  COPY_CODE("COPY_CODE"),
  
  OTP("OTP"),
  
  CATALOG("CATALOG"),
  
  MPM("MPM"),
  
  FLOW("FLOW");

  private String value;

  WhatsappTemplateComponentButtonType(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static WhatsappTemplateComponentButtonType fromValue(String value) {
    for (WhatsappTemplateComponentButtonType b : WhatsappTemplateComponentButtonType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<WhatsappTemplateComponentButtonType> {
    @Override
    public void write(final JsonWriter jsonWriter, final WhatsappTemplateComponentButtonType enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public WhatsappTemplateComponentButtonType read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return WhatsappTemplateComponentButtonType.fromValue(value);
    }
  }
}

