/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.ycloud.client.JSON;

/**
 * Use for &#x60;LIMITED_TIME_OFFER&#x60; components.
 */
@ApiModel(description = "Use for `LIMITED_TIME_OFFER` components.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class WhatsappTemplateComponentLimitedTimeOffer {
  public static final String SERIALIZED_NAME_TEXT = "text";
  /**
   * **Required.** Offer details text. Maximum 16 characters.
  **/
  @SerializedName(SERIALIZED_NAME_TEXT)
  private String text;

  public static final String SERIALIZED_NAME_HAS_EXPIRATION = "has_expiration";
  /**
   * **Optional.** Set to &#x60;true&#x60; to have the [offer expiration details](https://developers.facebook.com/docs/whatsapp/business-management-api/message-templates/limited-time-offer-templates#offer-expiration-details) appear in the delivered message. If set to &#x60;true&#x60;, the copy code button component must be included in the &#x60;buttons&#x60; array, and must appear first in the array. If set to &#x60;false&#x60;, offer expiration details will not appear in the delivered message and the copy code button component is optional. If including the copy code button, it must appear first in the &#x60;buttons&#x60; array.
  **/
  @SerializedName(SERIALIZED_NAME_HAS_EXPIRATION)
  private Boolean hasExpiration;

  public WhatsappTemplateComponentLimitedTimeOffer() { 
  }

  public WhatsappTemplateComponentLimitedTimeOffer text(String text) {
    
    this.text = text;
    return this;
  }

   /**
   * **Required.** Offer details text. Maximum 16 characters.
   * @return text
  **/
  @javax.annotation.Nullable

  public String getText() {
    return text;
  }


  /**
   * **Required.** Offer details text. Maximum 16 characters.
   **/
  @ApiModelProperty(example = "Expiring offer!", value = "**Required.** Offer details text. Maximum 16 characters.")
  public void setText(String text) {
    this.text = text;
  }


  public WhatsappTemplateComponentLimitedTimeOffer hasExpiration(Boolean hasExpiration) {
    
    this.hasExpiration = hasExpiration;
    return this;
  }

   /**
   * **Optional.** Set to &#x60;true&#x60; to have the [offer expiration details](https://developers.facebook.com/docs/whatsapp/business-management-api/message-templates/limited-time-offer-templates#offer-expiration-details) appear in the delivered message. If set to &#x60;true&#x60;, the copy code button component must be included in the &#x60;buttons&#x60; array, and must appear first in the array. If set to &#x60;false&#x60;, offer expiration details will not appear in the delivered message and the copy code button component is optional. If including the copy code button, it must appear first in the &#x60;buttons&#x60; array.
   * @return hasExpiration
  **/
  @javax.annotation.Nullable

  public Boolean getHasExpiration() {
    return hasExpiration;
  }


  /**
   * **Optional.** Set to &#x60;true&#x60; to have the [offer expiration details](https://developers.facebook.com/docs/whatsapp/business-management-api/message-templates/limited-time-offer-templates#offer-expiration-details) appear in the delivered message. If set to &#x60;true&#x60;, the copy code button component must be included in the &#x60;buttons&#x60; array, and must appear first in the array. If set to &#x60;false&#x60;, offer expiration details will not appear in the delivered message and the copy code button component is optional. If including the copy code button, it must appear first in the &#x60;buttons&#x60; array.
   **/
  @ApiModelProperty(value = "**Optional.** Set to `true` to have the [offer expiration details](https://developers.facebook.com/docs/whatsapp/business-management-api/message-templates/limited-time-offer-templates#offer-expiration-details) appear in the delivered message. If set to `true`, the copy code button component must be included in the `buttons` array, and must appear first in the array. If set to `false`, offer expiration details will not appear in the delivered message and the copy code button component is optional. If including the copy code button, it must appear first in the `buttons` array.")
  public void setHasExpiration(Boolean hasExpiration) {
    this.hasExpiration = hasExpiration;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   */
  public WhatsappTemplateComponentLimitedTimeOffer putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsappTemplateComponentLimitedTimeOffer whatsappTemplateComponentLimitedTimeOffer = (WhatsappTemplateComponentLimitedTimeOffer) o;
    return Objects.equals(this.text, whatsappTemplateComponentLimitedTimeOffer.text) &&
        Objects.equals(this.hasExpiration, whatsappTemplateComponentLimitedTimeOffer.hasExpiration)&&
        Objects.equals(this.additionalProperties, whatsappTemplateComponentLimitedTimeOffer.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(text, hasExpiration, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsappTemplateComponentLimitedTimeOffer {\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("    hasExpiration: ").append(toIndentedString(hasExpiration)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("text");
    openapiFields.add("has_expiration");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to WhatsappTemplateComponentLimitedTimeOffer
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (WhatsappTemplateComponentLimitedTimeOffer.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappTemplateComponentLimitedTimeOffer is not found in the empty JSON string", WhatsappTemplateComponentLimitedTimeOffer.openapiRequiredFields.toString()));
        }
      }
      if (jsonObj.get("text") != null && !jsonObj.get("text").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `text` to be a primitive type in the JSON string but got `%s`", jsonObj.get("text").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!WhatsappTemplateComponentLimitedTimeOffer.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'WhatsappTemplateComponentLimitedTimeOffer' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<WhatsappTemplateComponentLimitedTimeOffer> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(WhatsappTemplateComponentLimitedTimeOffer.class));

       return (TypeAdapter<T>) new TypeAdapter<WhatsappTemplateComponentLimitedTimeOffer>() {
           @Override
           public void write(JsonWriter out, WhatsappTemplateComponentLimitedTimeOffer value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additonal properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public WhatsappTemplateComponentLimitedTimeOffer read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             // store additional fields in the deserialized instance
             WhatsappTemplateComponentLimitedTimeOffer instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else { // non-primitive type
                   instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of WhatsappTemplateComponentLimitedTimeOffer given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of WhatsappTemplateComponentLimitedTimeOffer
  * @throws IOException if the JSON string is invalid with respect to WhatsappTemplateComponentLimitedTimeOffer
  */
  public static WhatsappTemplateComponentLimitedTimeOffer fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, WhatsappTemplateComponentLimitedTimeOffer.class);
  }

 /**
  * Convert an instance of WhatsappTemplateComponentLimitedTimeOffer to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

