/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import io.swagger.annotations.ApiModel;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * Quality rating of WhatsApp template. One of &#x60;GREEN&#x60;, &#x60;YELLOW&#x60;, &#x60;RED&#x60;, or &#x60;UNKNOWN&#x60;. See also [Template Quality Rating](https://developers.facebook.com/docs/whatsapp/message-templates/guidelines/#quality-rating). - &#x60;GREEN&#x60;: High quality. - &#x60;YELLOW&#x60;: Medium quality. - &#x60;RED&#x60;: Low quality. - &#x60;UNKNOWN&#x60;: Unknown quality.
 */
@JsonAdapter(WhatsappTemplateQualityRating.Adapter.class)
public enum WhatsappTemplateQualityRating {
  
  GREEN("GREEN"),
  
  YELLOW("YELLOW"),
  
  RED("RED"),
  
  UNKNOWN("UNKNOWN");

  private String value;

  WhatsappTemplateQualityRating(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static WhatsappTemplateQualityRating fromValue(String value) {
    for (WhatsappTemplateQualityRating b : WhatsappTemplateQualityRating.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<WhatsappTemplateQualityRating> {
    @Override
    public void write(final JsonWriter jsonWriter, final WhatsappTemplateQualityRating enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public WhatsappTemplateQualityRating read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return WhatsappTemplateQualityRating.fromValue(value);
    }
  }
}

