/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import io.swagger.annotations.ApiModel;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * The status of a WhatsApp template. - &#x60;PENDING&#x60;: The template is still under review. Review can take up to 24 hours. - &#x60;REJECTED&#x60;: The template has been rejected during review process. - &#x60;APPROVED&#x60;: The template is approved, and you may begin sending it to customers. - &#x60;PAUSED&#x60;: The template has been paused due to recurring negative feedback from customers. Message templates with this status cannot be sent to customers. See [Template Pausing](https://developers.facebook.com/docs/whatsapp/message-templates/guidelines#template-pausing). - &#x60;DISABLED&#x60;: The template has been disabled due to recurring negative feedback from customers or for violating one or more of our policies. Message templates with this status cannot be sent to customers. You may be able to edit a disabled message template and request an appeal. See [Appeals](https://developers.facebook.com/docs/whatsapp/message-templates/guidelines#appeals). - &#x60;IN_APPEAL&#x60;: The template is in appeal. See also [Template Appeals](https://developers.facebook.com/docs/whatsapp/message-templates/guidelines#appeals). - &#x60;DELETED&#x60;: The template is deleted.
 */
@JsonAdapter(WhatsappTemplateStatus.Adapter.class)
public enum WhatsappTemplateStatus {
  
  PENDING("PENDING"),
  
  REJECTED("REJECTED"),
  
  APPROVED("APPROVED"),
  
  PAUSED("PAUSED"),
  
  DISABLED("DISABLED"),
  
  IN_APPEAL("IN_APPEAL"),
  
  DELETED("DELETED");

  private String value;

  WhatsappTemplateStatus(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static WhatsappTemplateStatus fromValue(String value) {
    for (WhatsappTemplateStatus b : WhatsappTemplateStatus.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<WhatsappTemplateStatus> {
    @Override
    public void write(final JsonWriter jsonWriter, final WhatsappTemplateStatus enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public WhatsappTemplateStatus read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return WhatsappTemplateStatus.fromValue(value);
    }
  }
}

