/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import io.swagger.annotations.ApiModel;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * Used when an event happened on WhatsApp template status updates. - &#x60;PENDING&#x60;: Pending. - &#x60;APPROVED&#x60;: Approved. - &#x60;REJECTED&#x60;: Rejected. - &#x60;IN_APPEAL&#x60;: In appeal. See also [Template Appeals](https://developers.facebook.com/docs/whatsapp/message-templates/guidelines#appeals). - &#x60;PAUSED&#x60;: Paused. See also [Template Pausing](https://developers.facebook.com/docs/whatsapp/message-templates/guidelines#template-pausing). - &#x60;FLAGGED&#x60;: Flagged. The template is scheduled for disabling. - &#x60;DISABLED&#x60;: Disabled. See also [Template Pausing](https://developers.facebook.com/docs/whatsapp/message-templates/guidelines#template-pausing). - &#x60;REINSTATED&#x60;: Reinstated. - &#x60;PENDING_DELETION&#x60;: Pending deletion.
 */
@JsonAdapter(WhatsappTemplateStatusUpdateEventEnum.Adapter.class)
public enum WhatsappTemplateStatusUpdateEventEnum {
  
  PENDING("PENDING"),
  
  APPROVED("APPROVED"),
  
  REJECTED("REJECTED"),
  
  IN_APPEAL("IN_APPEAL"),
  
  PAUSED("PAUSED"),
  
  FLAGGED("FLAGGED"),
  
  DISABLED("DISABLED"),
  
  REINSTATED("REINSTATED"),
  
  PENDING_DELETION("PENDING_DELETION");

  private String value;

  WhatsappTemplateStatusUpdateEventEnum(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static WhatsappTemplateStatusUpdateEventEnum fromValue(String value) {
    for (WhatsappTemplateStatusUpdateEventEnum b : WhatsappTemplateStatusUpdateEventEnum.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<WhatsappTemplateStatusUpdateEventEnum> {
    @Override
    public void write(final JsonWriter jsonWriter, final WhatsappTemplateStatusUpdateEventEnum enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public WhatsappTemplateStatusUpdateEventEnum read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return WhatsappTemplateStatusUpdateEventEnum.fromValue(value);
    }
  }
}

