/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote;

import com.yoti.api.client.Date;
import com.yoti.api.client.DocumentDetails;
import com.yoti.api.client.spi.remote.DateAttributeValue;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class DocumentDetailsAttributeValue
implements DocumentDetails {
    private static final String DETAILS_REGEX = "([A-Za-z]*) ([A-Za-z]{3}) ([A-Za-z0-9]*) (.*)";
    private static final Pattern DETAILS_PATTERN = Pattern.compile("([A-Za-z]*) ([A-Za-z]{3}) ([A-Za-z0-9]*) (.*)");
    private static final int TYPE_GROUP = 1;
    private static final int COUNTRY_GROUP = 2;
    private static final int NUMBER_GROUP = 3;
    private static final int EXPIRATION_GROUP = 4;
    private final DocumentDetails.DocumentType type;
    private final String issuingCountry;
    private final Date expirationDate;
    private final String number;

    public DocumentDetailsAttributeValue(DocumentDetails.DocumentType type, String issuingCountry, Date expirationDate, String number) {
        this.type = type;
        this.issuingCountry = issuingCountry;
        this.expirationDate = expirationDate;
        this.number = number;
    }

    public static DocumentDetails parseFrom(String attribute) throws UnsupportedEncodingException, ParseException {
        Matcher matcher;
        DocumentDetailsAttributeValue result = null;
        if (attribute != null && (matcher = DETAILS_PATTERN.matcher(attribute)).matches()) {
            DocumentDetails.DocumentType type = DocumentDetails.DocumentType.valueOf((String)matcher.group(1));
            String issuingCountry = matcher.group(2);
            DateAttributeValue expirationDate = DateAttributeValue.parseFrom(matcher.group(4));
            String number = matcher.group(3);
            result = new DocumentDetailsAttributeValue(type, issuingCountry, expirationDate, number);
        }
        return result;
    }

    public DocumentDetails.DocumentType getType() {
        return this.type;
    }

    public String getIssuingCountry() {
        return this.issuingCountry;
    }

    public String getDocumentNumber() {
        return this.number;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }
}

