/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote;

import com.yoti.api.client.Date;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

final class DateAttributeValue
implements Date {
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final String STRING_ENCODING = "UTF-8";
    private final int year;
    private final int month;
    private final int day;

    private DateAttributeValue(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public static DateAttributeValue parseFrom(byte[] content) throws UnsupportedEncodingException, ParseException {
        String source = new String(content, STRING_ENCODING);
        return DateAttributeValue.parseFrom(source);
    }

    public static DateAttributeValue parseFrom(String source) throws UnsupportedEncodingException, ParseException {
        Calendar calendar = DateAttributeValue.parseDate(source);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        return new DateAttributeValue(year, month, day);
    }

    private static Calendar parseDate(String source) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        sdf.setLenient(false);
        java.util.Date date = sdf.parse(source);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }
}

