/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote;

import com.yoti.api.client.Attribute;
import com.yoti.api.client.Date;
import com.yoti.api.client.DocumentDetails;
import com.yoti.api.client.HumanProfile;
import com.yoti.api.client.Image;
import com.yoti.api.client.Profile;
import com.yoti.api.client.spi.remote.DocumentDetailsAttributeValue;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Collection;

final class HumanProfileAdapter
implements HumanProfile {
    private static final String ATTRIBUTE_FAMILY_NAME = "family_name";
    private static final String ATTRIBUTE_GIVEN_NAMES = "given_names";
    private static final String ATTRIBUTE_FULL_NAME = "full_name";
    private static final String ATTRIBUTE_DOB = "date_of_birth";
    private static final String ATTRIBUTE_GENDER = "gender";
    private static final String ATTRIBUTE_NATIONALITY = "nationality";
    private static final String ATTRIBUTE_PHONE_NUMBER = "phone_number";
    private static final String ATTRIBUTE_SELFIE = "selfie";
    private static final String ATTRIBUTE_ADDRESS = "email_address";
    private static final String ATTRIBUTE_DOCUMENT_DETAILS = "document_details";
    private static final char SPACE = ' ';
    private final Profile wrapped;

    private HumanProfileAdapter(Profile wrapped) {
        this.wrapped = wrapped;
    }

    public static HumanProfile wrap(Profile wrapped) {
        return new HumanProfileAdapter(wrapped);
    }

    public String getAttribute(String name) {
        return this.wrapped.getAttribute(name);
    }

    public boolean is(String name, boolean defaultValue) {
        return this.wrapped.is(name, defaultValue);
    }

    public <T> T getAttribute(String name, Class<T> clazz) {
        return (T)this.wrapped.getAttribute(name, clazz);
    }

    public Collection<Attribute> getAttributes() {
        return this.wrapped.getAttributes();
    }

    public String getFamilyName() {
        return this.wrapped.getAttribute(ATTRIBUTE_FAMILY_NAME);
    }

    public String getGivenNames() {
        return this.wrapped.getAttribute(ATTRIBUTE_GIVEN_NAMES);
    }

    @Deprecated
    public String getFullName() {
        return this.wrapped.getAttribute(ATTRIBUTE_FULL_NAME);
    }

    public String getGivenAndLastNames() {
        String givenNames = this.getGivenNames();
        String familyName = this.getFamilyName();
        if (givenNames == null && familyName == null) {
            return null;
        }
        return this.buildGivenAndLastNameString(givenNames, familyName);
    }

    public Date getDateOfBirth() {
        return (Date)this.wrapped.getAttribute(ATTRIBUTE_DOB, Date.class);
    }

    public HumanProfile.Gender getGender() {
        String genderString = this.wrapped.getAttribute(ATTRIBUTE_GENDER);
        if (genderString != null) {
            try {
                return HumanProfile.Gender.valueOf((String)genderString);
            }
            catch (IllegalArgumentException isa) {
                return HumanProfile.Gender.OTHER;
            }
        }
        return null;
    }

    public String getNationality() {
        return this.wrapped.getAttribute(ATTRIBUTE_NATIONALITY);
    }

    public String getPhoneNumber() {
        return this.wrapped.getAttribute(ATTRIBUTE_PHONE_NUMBER);
    }

    public Image getSelfie() {
        return (Image)this.wrapped.getAttribute(ATTRIBUTE_SELFIE, Image.class);
    }

    public String getEmailAddress() {
        return this.wrapped.getAttribute(ATTRIBUTE_ADDRESS);
    }

    public DocumentDetails getDocumentDetails() {
        try {
            return DocumentDetailsAttributeValue.parseFrom(this.wrapped.getAttribute(ATTRIBUTE_DOCUMENT_DETAILS));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.wrapped == null ? 0 : this.wrapped.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HumanProfileAdapter other = (HumanProfileAdapter)obj;
        return !(this.wrapped == null ? other.wrapped != null : !this.wrapped.equals(other.wrapped));
    }

    private String buildGivenAndLastNameString(String givenNames, String familyName) {
        StringBuilder result = new StringBuilder();
        this.appendIfNotNull(result, givenNames);
        if (givenNames != null && familyName != null) {
            result.append(' ');
        }
        this.appendIfNotNull(result, familyName);
        return result.toString();
    }

    private void appendIfNotNull(StringBuilder builder, String input) {
        if (input != null) {
            builder.append(input);
        }
    }
}

