/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote;

import com.yoti.api.client.Attribute;
import com.yoti.api.client.Profile;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class SimpleProfile
implements Profile {
    private final Map<String, Attribute> attributes;
    private final Map<String, Attribute> protectedAttributes;

    public SimpleProfile(Map<String, Object> objectAttributes) {
        if (objectAttributes == null) {
            throw new IllegalArgumentException("Attributes must not be null.");
        }
        this.attributes = this.createAttributeMap(objectAttributes);
        this.protectedAttributes = Collections.unmodifiableMap(this.attributes);
    }

    public String getAttribute(String name) {
        Attribute attribute = this.doGetAttribute(name);
        return attribute == null ? null : (String)attribute.getValue(String.class);
    }

    public boolean is(String name, boolean defaultValue) {
        Attribute attribute = this.doGetAttribute(name);
        return attribute == null ? defaultValue : (Boolean)attribute.getValueOrDefault(Boolean.class, (Object)defaultValue);
    }

    public <T> T getAttribute(String name, Class<T> clazz) {
        Attribute attribute = this.doGetAttribute(name);
        return (T)(attribute == null ? null : attribute.getValue(clazz));
    }

    public Collection<Attribute> getAttributes() {
        return this.protectedAttributes.values();
    }

    private Map<String, Attribute> createAttributeMap(Map<String, Object> objectAttributes) {
        HashMap<String, Attribute> result = new HashMap<String, Attribute>();
        for (Map.Entry<String, Object> e : objectAttributes.entrySet()) {
            result.put(e.getKey(), new Attribute(e.getKey(), e.getValue()));
        }
        return result;
    }

    private Attribute doGetAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name must not be null.");
        }
        return this.attributes.get(name);
    }
}

