/*
 * Decompiled with CFR 0.152.
 */
package de.aaschmid.taskwarrior.client;

import de.aaschmid.taskwarrior.client.TaskwarriorKeyStoreException;
import de.aaschmid.taskwarrior.thirdparty.org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import de.aaschmid.taskwarrior.thirdparty.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import de.aaschmid.taskwarrior.thirdparty.org.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import de.aaschmid.taskwarrior.thirdparty.org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import de.aaschmid.taskwarrior.thirdparty.org.bouncycastle.util.io.pem.PemObject;
import de.aaschmid.taskwarrior.thirdparty.org.bouncycastle.util.io.pem.PemReader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

class KeyStoreBuilder {
    private static final String CERTIFICATE_TYPE = "X.509";
    private static final String KEY_ALGORITHM_RSA = "RSA";
    private static final String PEM_TYPE_PKCS1 = "RSA PRIVATE KEY";
    private static final String PEM_TYPE_PKCS8 = "PRIVATE KEY";
    private KeyStore.ProtectionParameter keyStoreProtection;
    private File caCertFile;
    private File privateKeyCertFile;
    private File privateKeyFile;

    KeyStoreBuilder() {
    }

    KeyStoreBuilder withKeyStoreProtection(KeyStore.ProtectionParameter keyStoreProtection) {
        this.keyStoreProtection = Objects.requireNonNull(keyStoreProtection, "'keyStoreProtection' must not be null.");
        return this;
    }

    KeyStoreBuilder withPasswordProtection(String password) {
        return this.withKeyStoreProtection(new KeyStore.PasswordProtection(Objects.requireNonNull(password, "'password' must not be null.").toCharArray()));
    }

    KeyStoreBuilder withCaCertFile(File caCertFile) {
        Objects.requireNonNull(caCertFile, "'caCertFile' must not be null.");
        if (!caCertFile.exists()) {
            throw new IllegalArgumentException(String.format("CA certificate '%s' does not exist.", caCertFile));
        }
        this.caCertFile = caCertFile;
        return this;
    }

    KeyStoreBuilder withPrivateKeyCertFile(File privateKeyCertFile) {
        Objects.requireNonNull(privateKeyCertFile, "'privateKeyCertFile' must not be null.");
        if (!privateKeyCertFile.exists()) {
            throw new IllegalArgumentException(String.format("Private key certificate '%s' does not exist.", privateKeyCertFile));
        }
        this.privateKeyCertFile = privateKeyCertFile;
        return this;
    }

    KeyStoreBuilder withPrivateKeyFile(File privateKeyFile) {
        Objects.requireNonNull(privateKeyFile, "'privateKeyFile' must not be null.");
        if (!privateKeyFile.exists()) {
            throw new IllegalArgumentException(String.format("Private key '%s' does not exist.", privateKeyFile));
        }
        this.privateKeyFile = privateKeyFile;
        return this;
    }

    KeyStore build() {
        KeyStore result;
        try {
            result = KeyStore.Builder.newInstance(KeyStore.getDefaultType(), null, this.keyStoreProtection).getKeyStore();
        }
        catch (KeyStoreException e) {
            throw new TaskwarriorKeyStoreException(e, "Could not build keystore: %s", e.getMessage());
        }
        AtomicInteger idx = new AtomicInteger(0);
        this.createCertificatesFor(this.caCertFile).forEach(c -> {
            try {
                result.setCertificateEntry("ca_" + idx.getAndIncrement(), (Certificate)c);
            }
            catch (KeyStoreException e) {
                throw new TaskwarriorKeyStoreException(e, "Could not add CA certificate '%s' to keystore.", this.caCertFile);
            }
        });
        Certificate[] privateKeyCertsChain = this.createCertificatesFor(this.privateKeyCertFile).toArray(new Certificate[0]);
        PrivateKey privateKey = this.createPrivateKeyFor(this.privateKeyFile);
        try {
            result.setEntry("key", new KeyStore.PrivateKeyEntry(privateKey, privateKeyCertsChain), this.keyStoreProtection);
        }
        catch (KeyStoreException e) {
            throw new TaskwarriorKeyStoreException(e, "Could not create private cert '%s' and key '%s' to keystore.", this.privateKeyCertFile, this.privateKeyFile);
        }
        return result;
    }

    private List<Certificate> createCertificatesFor(File certFile) {
        ArrayList<Certificate> result = new ArrayList<Certificate>();
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(certFile));){
            CertificateFactory cf = CertificateFactory.getInstance(CERTIFICATE_TYPE);
            while (bis.available() > 0) {
                result.add(cf.generateCertificate(bis));
            }
        }
        catch (IOException e) {
            throw new TaskwarriorKeyStoreException(e, "Could not read certificates of '%s' via input stream.", certFile);
        }
        catch (CertificateException e) {
            throw new TaskwarriorKeyStoreException(e, "Could not generate certificates for '%s'.", certFile);
        }
        return result;
    }

    private PrivateKey createPrivateKeyFor(File privateKeyFile) {
        try {
            byte[] bytes = Files.readAllBytes(privateKeyFile.toPath());
            if (privateKeyFile.getName().endsWith("pem")) {
                PemReader pemReader = new PemReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), StandardCharsets.UTF_8));
                PemObject privateKeyObject = pemReader.readPemObject();
                switch (privateKeyObject.getType()) {
                    case "RSA PRIVATE KEY": {
                        return this.createPrivateKeyForPkcs1(privateKeyObject.getContent());
                    }
                    case "PRIVATE KEY": {
                        return this.createPrivateKeyForPkcs8(privateKeyObject.getContent());
                    }
                }
                throw new TaskwarriorKeyStoreException("Unsupported key algorithm '%s'.", privateKeyObject.getType());
            }
            return this.createPrivateKeyForPkcs8(bytes);
        }
        catch (IOException e) {
            throw new TaskwarriorKeyStoreException(e, "Could not read private key of '%s' via input stream.", privateKeyFile);
        }
    }

    private PrivateKey createPrivateKeyForPkcs1(byte[] privateKeyBytes) {
        RSAPrivateKey rsa = RSAPrivateKey.getInstance(privateKeyBytes);
        RSAPrivateCrtKeyParameters keyParameters = new RSAPrivateCrtKeyParameters(rsa.getModulus(), rsa.getPublicExponent(), rsa.getPrivateExponent(), rsa.getPrime1(), rsa.getPrime2(), rsa.getExponent1(), rsa.getExponent2(), rsa.getCoefficient());
        try {
            return new JcaPEMKeyConverter().getPrivateKey(PrivateKeyInfoFactory.createPrivateKeyInfo(keyParameters));
        }
        catch (IOException e) {
            throw new TaskwarriorKeyStoreException(e, "Failed to encode PKCS#1 private key of '%s'.", this.privateKeyFile);
        }
    }

    private PrivateKey createPrivateKeyForPkcs8(byte[] privateKeyBytes) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM_RSA);
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKeyBytes));
        }
        catch (NoSuchAlgorithmException e) {
            throw new TaskwarriorKeyStoreException(e, "Key factory could not be initialized for algorithm '%s'.", KEY_ALGORITHM_RSA);
        }
        catch (InvalidKeySpecException e) {
            throw new TaskwarriorKeyStoreException(e, "Invalid key spec for %s private key in '%s'.", KEY_ALGORITHM_RSA, this.privateKeyFile);
        }
    }
}

