/*
 * Decompiled with CFR 0.152.
 */
package de.aaschmid.taskwarrior.client;

import de.aaschmid.taskwarrior.client.KeyStoreBuilder;
import de.aaschmid.taskwarrior.client.TaskwarriorSslContextException;
import de.aaschmid.taskwarrior.client.TaskwarriorSslKeys;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.Objects;
import java.util.UUID;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

class SslContextFactory {
    private static final String DEFAULT_PROTOCOL = "TLS";

    SslContextFactory() {
    }

    static SSLContext createSslContext(TaskwarriorSslKeys sslKeys) {
        Objects.requireNonNull(sslKeys, "'sslKeys' must not be null.");
        String keystorePassword = UUID.randomUUID().toString();
        KeyStore keyStore = new KeyStoreBuilder().withPasswordProtection(keystorePassword).withCaCertFile(sslKeys.getCaCertFile()).withPrivateKeyCertFile(sslKeys.getPrivateKeyCertFile()).withPrivateKeyFile(sslKeys.getPrivateKeyFile()).build();
        return SslContextFactory.createSslContext(DEFAULT_PROTOCOL, keyStore, keystorePassword);
    }

    static SSLContext createSslContext(String protocol, KeyStore keyStore, String keyStorePassword) {
        SSLContext sslContext;
        Objects.requireNonNull(protocol, "'protocol' must not be null.");
        Objects.requireNonNull(keyStore, "'keyStore' must not be null.");
        Objects.requireNonNull(keyStorePassword, "'keyStorePassword' must not be null.");
        try {
            sslContext = SSLContext.getInstance(protocol);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TaskwarriorSslContextException(e, "Cannot create SSL context for protocol '%s'.", protocol);
        }
        try {
            sslContext.init(SslContextFactory.loadKeyMaterial(keyStore, keyStorePassword), SslContextFactory.loadTrustMaterial(keyStore), null);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new TaskwarriorSslContextException(e, "Could not init ssl context: %s", e.getMessage());
        }
        return sslContext;
    }

    private static KeyManager[] loadKeyMaterial(KeyStore keystore, String keyStorePassword) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        KeyManagerFactory result = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        result.init(keystore, keyStorePassword.toCharArray());
        return result.getKeyManagers();
    }

    private static TrustManager[] loadTrustMaterial(KeyStore truststore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory result = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        result.init(truststore);
        return result.getTrustManagers();
    }
}

