/*
 * Decompiled with CFR 0.152.
 */
package de.aaschmid.taskwarrior.client;

import de.aaschmid.taskwarrior.client.SslContextFactory;
import de.aaschmid.taskwarrior.client.TaskwarriorClientException;
import de.aaschmid.taskwarrior.client.TaskwarriorMessageFactory;
import de.aaschmid.taskwarrior.config.TaskwarriorConfiguration;
import de.aaschmid.taskwarrior.message.TaskwarriorMessage;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Objects;
import javax.net.ssl.SSLContext;

public class TaskwarriorClient {
    private final TaskwarriorConfiguration config;
    private final SSLContext sslContext;

    public TaskwarriorClient(TaskwarriorConfiguration config) {
        this.config = Objects.requireNonNull(config, "'configuration' must not be null.");
        this.sslContext = SslContextFactory.createSslContext(config);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="generated try-with-resources code causes failure in Java 11, see https://github.com/spotbugs/spotbugs/issues/756")
    public TaskwarriorMessage sendAndReceive(TaskwarriorMessage message) {
        TaskwarriorMessage taskwarriorMessage;
        block8: {
            Objects.requireNonNull(message, "'message' must not be null.");
            Socket socket = this.sslContext.getSocketFactory().createSocket(this.config.getServerHost(), this.config.getServerPort());
            try {
                taskwarriorMessage = this.sendAndReceive(socket, message);
                if (socket == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new TaskwarriorClientException(e, "Could not create socket connection to '%s:%d'.", this.config.getServerHost().getCanonicalHostName(), this.config.getServerPort());
                }
            }
            socket.close();
        }
        return taskwarriorMessage;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="generated try-with-resources code causes failure in Java 11, see https://github.com/spotbugs/spotbugs/issues/756")
    private TaskwarriorMessage sendAndReceive(Socket socket, TaskwarriorMessage message) {
        try (OutputStream out = socket.getOutputStream();){
            TaskwarriorMessage taskwarriorMessage;
            block14: {
                InputStream in = socket.getInputStream();
                try {
                    this.send(out, message);
                    taskwarriorMessage = this.receive(in);
                    if (in == null) break block14;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return taskwarriorMessage;
        }
        catch (IOException e) {
            throw new TaskwarriorClientException("Could not open input and/or output stream of socket.", new Object[]{e});
        }
    }

    private void send(OutputStream out, TaskwarriorMessage message) {
        try {
            out.write(TaskwarriorMessageFactory.serialize(message));
            out.flush();
        }
        catch (IOException e) {
            throw new TaskwarriorClientException("Could not write and flush serialized message to output stream of socket.", new Object[]{e});
        }
    }

    private TaskwarriorMessage receive(InputStream in) {
        return TaskwarriorMessageFactory.deserialize(in);
    }
}

