/*
 * Decompiled with CFR 0.152.
 */
package de.aaschmid.taskwarrior.config;

import de.aaschmid.taskwarrior.config.TaskwarriorConfiguration;
import de.aaschmid.taskwarrior.config.TaskwarriorConfigurationException;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;

public class TaskwarriorPropertiesConfiguration
implements TaskwarriorConfiguration {
    private final URL propertiesUrl;
    private final Properties taskwarriorProperties;

    TaskwarriorPropertiesConfiguration(URL propertiesUrl) {
        this.propertiesUrl = Objects.requireNonNull(propertiesUrl, "'propertiesUrl' must not be null.");
        this.taskwarriorProperties = new Properties();
        try {
            this.taskwarriorProperties.load(propertiesUrl.openStream());
        }
        catch (IOException e) {
            throw new TaskwarriorConfigurationException(e, "Cannot read '%s'. Check file existence and permissions.", propertiesUrl);
        }
    }

    @Override
    public File getCaCertFile() {
        return this.getExistingFileFromProperty(PropertyKey.SSL_CERT_CA_FILE.key, "CA certificate");
    }

    @Override
    public File getPrivateKeyCertFile() {
        return this.getExistingFileFromProperty(PropertyKey.SSL_PRIVATE_KEY_CERT_FILE.key, "Private key certificate");
    }

    @Override
    public File getPrivateKeyFile() {
        return this.getExistingFileFromProperty(PropertyKey.SSL_PRIVATE_KEY_FILE.key, "Private key");
    }

    @Override
    public InetAddress getServerHost() {
        String host = this.getExistingProperty(PropertyKey.SERVER_HOST.key);
        try {
            return InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new TaskwarriorConfigurationException(e, "Cannot resolve host address '%s'.", host);
        }
    }

    @Override
    public int getServerPort() {
        String port = this.getExistingProperty(PropertyKey.SERVER_PORT.key);
        try {
            return Integer.decode(port);
        }
        catch (NumberFormatException e) {
            throw new TaskwarriorConfigurationException(e, "Cannot resolve port '%s' because it is not a parsable.", port);
        }
    }

    @Override
    public String getOrganization() {
        return this.getExistingProperty(PropertyKey.ORGANIZATION.key);
    }

    @Override
    public UUID getAuthKey() {
        String key = this.getExistingProperty(PropertyKey.AUTH_KEY.key);
        try {
            return UUID.fromString(key);
        }
        catch (IllegalArgumentException e) {
            throw new TaskwarriorConfigurationException(e, "Authentication key '%s' is not a parsable UUID.", key);
        }
    }

    @Override
    public String getUser() {
        return this.getExistingProperty(PropertyKey.USER.key);
    }

    private String getExistingProperty(String key) {
        String value = this.taskwarriorProperties.getProperty(key);
        if (value == null) {
            throw new TaskwarriorConfigurationException("Could not find property with key '%s' in '%s'.", key, this.propertiesUrl);
        }
        return value;
    }

    private File getExistingFileFromProperty(String key, String fileErrorText) {
        String property = this.getExistingProperty(key);
        File result = new File(property);
        if (!result.exists()) {
            throw new TaskwarriorConfigurationException("%s file '%s' does not exist.", fileErrorText, property);
        }
        return result;
    }

    static enum PropertyKey {
        AUTH_KEY("taskwarrior.auth.key"),
        ORGANIZATION("taskwarrior.auth.organization"),
        USER("taskwarrior.auth.user"),
        SERVER_HOST("taskwarrior.server.host"),
        SERVER_PORT("taskwarrior.server.port"),
        SSL_CERT_CA_FILE("taskwarrior.ssl.cert.ca.file"),
        SSL_PRIVATE_KEY_CERT_FILE("taskwarrior.ssl.cert.key.file"),
        SSL_PRIVATE_KEY_FILE("taskwarrior.ssl.private.key.file");

        public final String key;

        private PropertyKey(String key) {
            this.key = key;
        }
    }
}

