/*
 * Decompiled with CFR 0.152.
 */
package de.bripkens.gravatar;

import de.bripkens.gravatar.DefaultImage;
import de.bripkens.gravatar.Rating;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.codec.digest.DigestUtils;

public class Gravatar {
    public static final String URL = "http://www.gravatar.com/avatar/";
    public static final String HTTPS_URL = "https://secure.gravatar.com/avatar/";
    public static final String FILE_TYPE_EXTENSION = ".jpg";
    public static final int DEFAULT_SIZE = 80;
    public static final Rating DEFAULT_RATING = Rating.GENERAL_AUDIENCE;
    private int size = 80;
    private boolean https;
    private boolean forceDefault;
    private Rating rating = DEFAULT_RATING;
    private DefaultImage standardDefaultImage;
    private String customDefaultImage;

    public int getSize() {
        return this.size;
    }

    public Gravatar setSize(int size) {
        assert (size > 0 && size < 2049);
        this.size = size;
        return this;
    }

    public boolean isHttps() {
        return this.https;
    }

    public Gravatar setHttps(boolean https) {
        this.https = https;
        return this;
    }

    public boolean isForceDefault() {
        return this.forceDefault;
    }

    public Gravatar setForceDefault(boolean forceDefault) {
        this.forceDefault = forceDefault;
        return this;
    }

    public Rating getRating() {
        return this.rating;
    }

    public Gravatar setRating(Rating rating) {
        assert (rating != null);
        this.rating = rating;
        return this;
    }

    public DefaultImage getStandardDefaultImage() {
        return this.standardDefaultImage;
    }

    public Gravatar setStandardDefaultImage(DefaultImage standardDefaultImage) {
        assert (standardDefaultImage != null);
        this.standardDefaultImage = standardDefaultImage;
        this.customDefaultImage = null;
        return this;
    }

    public Gravatar setCustomDefaultImage(String customDefaultImage, String encoding) throws UnsupportedEncodingException {
        assert (customDefaultImage != null && encoding != null);
        this.customDefaultImage = URLEncoder.encode(customDefaultImage, encoding);
        this.standardDefaultImage = null;
        return this;
    }

    public String getCustomDefaultImage() {
        return this.customDefaultImage;
    }

    public Gravatar setCustomDefaultImage(String customDefaultImage) throws UnsupportedEncodingException {
        return this.setCustomDefaultImage(customDefaultImage, "UTF-8");
    }

    public String getUrl(String email) {
        if (email == null) {
            throw new IllegalArgumentException("Email can't be null.");
        }
        String emailHash = DigestUtils.md5Hex((String)email.trim().toLowerCase());
        boolean firstParameter = true;
        StringBuilder builder = new StringBuilder(91).append(this.https ? HTTPS_URL : URL).append(emailHash).append(FILE_TYPE_EXTENSION);
        if (this.size != 80) {
            this.addParameter(builder, "s", Integer.toString(this.size), firstParameter);
            firstParameter = false;
        }
        if (this.forceDefault) {
            this.addParameter(builder, "f", "y", firstParameter);
            firstParameter = false;
        }
        if (this.rating != DEFAULT_RATING) {
            this.addParameter(builder, "r", this.rating.getKey(), firstParameter);
            firstParameter = false;
        }
        if (this.customDefaultImage != null) {
            this.addParameter(builder, "d", this.customDefaultImage, firstParameter);
        } else if (this.standardDefaultImage != null) {
            this.addParameter(builder, "d", this.standardDefaultImage.getKey(), firstParameter);
        }
        return builder.toString();
    }

    private void addParameter(StringBuilder builder, String key, String value, boolean firstParameter) {
        if (firstParameter) {
            builder.append("?");
        } else {
            builder.append("&");
        }
        builder.append(key).append("=").append(value);
    }
}

