/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.fcmjava.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.bytefish.fcmjava.client.interceptors.request.AuthenticationRequestInterceptor;
import de.bytefish.fcmjava.client.interceptors.request.JsonRequestInterceptor;
import de.bytefish.fcmjava.client.interceptors.request.LoggingRequestInterceptor;
import de.bytefish.fcmjava.client.interceptors.response.LoggingResponseInterceptor;
import de.bytefish.fcmjava.client.interceptors.response.StatusResponseInterceptor;
import de.bytefish.fcmjava.http.client.IFcmClient;
import de.bytefish.fcmjava.http.options.IFcmClientSettings;
import de.bytefish.fcmjava.requests.data.DataMulticastMessage;
import de.bytefish.fcmjava.requests.data.DataUnicastMessage;
import de.bytefish.fcmjava.requests.groups.AddDeviceGroupMessage;
import de.bytefish.fcmjava.requests.groups.CreateDeviceGroupMessage;
import de.bytefish.fcmjava.requests.groups.RemoveDeviceGroupMessage;
import de.bytefish.fcmjava.requests.notification.NotificationMulticastMessage;
import de.bytefish.fcmjava.requests.notification.NotificationUnicastMessage;
import de.bytefish.fcmjava.requests.topic.TopicMulticastMessage;
import de.bytefish.fcmjava.requests.topic.TopicUnicastMessage;
import de.bytefish.fcmjava.responses.CreateDeviceGroupMessageResponse;
import de.bytefish.fcmjava.responses.MulticastMessageResponse;
import de.bytefish.fcmjava.responses.TopicMessageResponse;
import de.bytefish.fcmjava.responses.UnicastMessageResponse;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class FcmClient
implements IFcmClient {
    private static final ObjectMapper mapper = new ObjectMapper();
    private final IFcmClientSettings settings;
    private final HttpClientBuilder httpClientBuilder;

    public FcmClient(IFcmClientSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException("settings");
        }
        this.settings = settings;
        this.httpClientBuilder = HttpClientBuilder.create().addInterceptorFirst((HttpRequestInterceptor)new AuthenticationRequestInterceptor(settings.getApiKey())).addInterceptorLast((HttpRequestInterceptor)new JsonRequestInterceptor()).addInterceptorLast((HttpRequestInterceptor)new LoggingRequestInterceptor()).addInterceptorFirst((HttpResponseInterceptor)new LoggingResponseInterceptor()).addInterceptorLast((HttpResponseInterceptor)new StatusResponseInterceptor());
    }

    public MulticastMessageResponse send(DataMulticastMessage message) {
        return this.post(message, MulticastMessageResponse.class);
    }

    public MulticastMessageResponse send(NotificationMulticastMessage notification) {
        return this.post(notification, MulticastMessageResponse.class);
    }

    public UnicastMessageResponse send(DataUnicastMessage message) {
        return this.post(message, UnicastMessageResponse.class);
    }

    public UnicastMessageResponse send(NotificationUnicastMessage notification) {
        return this.post(notification, UnicastMessageResponse.class);
    }

    public CreateDeviceGroupMessageResponse send(CreateDeviceGroupMessage message) {
        return this.post(message, CreateDeviceGroupMessageResponse.class);
    }

    public TopicMessageResponse send(TopicUnicastMessage message) {
        return this.post(message, TopicMessageResponse.class);
    }

    public TopicMessageResponse send(TopicMulticastMessage message) {
        return this.post(message, TopicMessageResponse.class);
    }

    public void send(RemoveDeviceGroupMessage message) {
        this.post(message);
    }

    public void send(AddDeviceGroupMessage message) {
        this.post(message);
    }

    private <TRequestMessage> void InternalPost(TRequestMessage requestMessage) throws Exception {
        try (CloseableHttpClient client = this.httpClientBuilder.build();){
            HttpPost httpPost = new HttpPost(this.settings.getFcmUrl());
            httpPost.setEntity((HttpEntity)new StringEntity(this.getJsonString(requestMessage)));
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);){
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    EntityUtils.consume((HttpEntity)entity);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private <TRequestMessage, TResponseMessage> TResponseMessage InternalPost(TRequestMessage requestMessage, Class<TResponseMessage> responseType) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 31[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected <TRequestMessage, TResponseMessage> TResponseMessage post(TRequestMessage requestMessage, Class<TResponseMessage> responseType) {
        try {
            return this.InternalPost(requestMessage, responseType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected <TRequestMessage> void post(TRequestMessage requestMessage) {
        try {
            this.InternalPost(requestMessage);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <TEntity> String getJsonString(TEntity source) throws Exception {
        if (source == null) {
            throw new IllegalArgumentException("source");
        }
        return mapper.writeValueAsString(source);
    }

    private <TEntity> TEntity getEntity(String source, Class<TEntity> valueType) throws Exception {
        return (TEntity)mapper.readValue(source, valueType);
    }
}

