/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.fcmjava.client.interceptors.response;

import de.bytefish.fcmjava.exceptions.FcmAuthenticationException;
import de.bytefish.fcmjava.exceptions.FcmBadRequestException;
import de.bytefish.fcmjava.exceptions.FcmGeneralException;
import de.bytefish.fcmjava.exceptions.FcmUnavailableException;
import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;

public class StatusResponseInterceptor
implements HttpResponseInterceptor {
    public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        if (httpResponse == null) {
            return;
        }
        if (httpResponse.getStatusLine() == null) {
            return;
        }
        int httpStatusCode = httpResponse.getStatusLine().getStatusCode();
        if (httpStatusCode == 200) {
            return;
        }
        String reasonPhrase = httpResponse.getStatusLine().getReasonPhrase();
        switch (httpStatusCode) {
            case 400: {
                throw new FcmBadRequestException(reasonPhrase);
            }
            case 401: {
                throw new FcmAuthenticationException(reasonPhrase);
            }
            case 503: {
                throw new FcmUnavailableException(reasonPhrase);
            }
        }
        throw new FcmGeneralException(reasonPhrase);
    }
}

