/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.fcmjava.client.interceptors.response;

import de.bytefish.fcmjava.client.utils.OutParameter;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingResponseInterceptor
implements HttpResponseInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LoggingResponseInterceptor.class);

    public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        OutParameter<String> httpResponseString;
        if (log.isDebugEnabled() && this.tryGetResponseBody(httpResponse, httpResponseString = new OutParameter<String>())) {
            log.debug(httpResponseString.get());
        }
    }

    private boolean tryGetResponseBody(HttpResponse httpResponse, OutParameter<String> httpEntityString) {
        if (httpResponse == null) {
            return false;
        }
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity == null) {
            return false;
        }
        return this.tryGetEntityString(httpEntity, httpEntityString);
    }

    private boolean tryGetEntityString(HttpEntity httpEntity, OutParameter<String> httpEntityString) {
        try {
            httpEntityString.set(EntityUtils.toString((HttpEntity)httpEntity));
            return true;
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Failed to get the HttpEntity Content", (Throwable)e);
            }
            return false;
        }
    }
}

