/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.fcmjava.client.http;

import de.bytefish.fcmjava.client.functional.Action1;
import de.bytefish.fcmjava.client.http.IHttpClient;
import de.bytefish.fcmjava.client.interceptors.request.AuthenticationRequestInterceptor;
import de.bytefish.fcmjava.client.interceptors.request.JsonRequestInterceptor;
import de.bytefish.fcmjava.client.interceptors.response.StatusResponseInterceptor;
import de.bytefish.fcmjava.client.utils.JsonUtils;
import de.bytefish.fcmjava.http.options.IFcmClientSettings;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class HttpClient
implements IHttpClient {
    private final IFcmClientSettings settings;
    private final HttpClientBuilder httpClientBuilder;

    public HttpClient(IFcmClientSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException("settings");
        }
        this.settings = settings;
        this.httpClientBuilder = HttpClientBuilder.create().addInterceptorFirst((HttpRequestInterceptor)new AuthenticationRequestInterceptor(settings.getApiKey())).addInterceptorLast((HttpRequestInterceptor)new JsonRequestInterceptor()).addInterceptorLast((HttpResponseInterceptor)new StatusResponseInterceptor());
    }

    public HttpClient configure(Action1<HttpClientBuilder> configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration");
        }
        configuration.invoke(this.httpClientBuilder);
        return this;
    }

    @Override
    public <TRequestMessage, TResponseMessage> TResponseMessage post(TRequestMessage requestMessage, Class<TResponseMessage> responseType) {
        try {
            return this.internalPost(requestMessage, responseType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <TRequestMessage> void post(TRequestMessage requestMessage) {
        try {
            this.internalPost(requestMessage);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <TRequestMessage> void internalPost(TRequestMessage requestMessage) throws Exception {
        try (CloseableHttpClient client = this.httpClientBuilder.build();){
            HttpPost httpPost = new HttpPost(this.settings.getFcmUrl());
            httpPost.setEntity((HttpEntity)new StringEntity(JsonUtils.getAsJsonString(requestMessage), StandardCharsets.UTF_8));
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);){
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    EntityUtils.consume((HttpEntity)entity);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private <TRequestMessage, TResponseMessage> TResponseMessage internalPost(TRequestMessage requestMessage, Class<TResponseMessage> responseType) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 31[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

