/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.fcmjava.client.interceptors.response;

import de.bytefish.fcmjava.client.interceptors.response.utils.RetryHeaderUtils;
import de.bytefish.fcmjava.client.utils.OutParameter;
import de.bytefish.fcmjava.exceptions.FcmAuthenticationException;
import de.bytefish.fcmjava.exceptions.FcmBadRequestException;
import de.bytefish.fcmjava.exceptions.FcmGeneralException;
import de.bytefish.fcmjava.exceptions.FcmRetryAfterException;
import java.io.IOException;
import java.time.Duration;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;

public class StatusResponseInterceptor
implements HttpResponseInterceptor {
    public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        OutParameter<Duration> result;
        if (httpResponse == null) {
            return;
        }
        if (httpResponse.getStatusLine() == null) {
            return;
        }
        int httpStatusCode = httpResponse.getStatusLine().getStatusCode();
        if (httpStatusCode == 200) {
            return;
        }
        String reasonPhrase = httpResponse.getStatusLine().getReasonPhrase();
        if (httpStatusCode == 400) {
            throw new FcmBadRequestException(reasonPhrase);
        }
        if (httpStatusCode == 401) {
            throw new FcmAuthenticationException(reasonPhrase);
        }
        if (httpStatusCode >= 500 && httpStatusCode < 600 && RetryHeaderUtils.tryDetermineRetryDelay(httpResponse, result = new OutParameter<Duration>())) {
            throw new FcmRetryAfterException(result.get(), reasonPhrase);
        }
        throw new FcmGeneralException(reasonPhrase);
    }
}

