/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.fcmjava.client.http.apache.utils;

import de.bytefish.fcmjava.client.utils.DateUtils;
import de.bytefish.fcmjava.client.utils.OutParameter;
import de.bytefish.fcmjava.client.utils.StringUtils;
import java.time.Duration;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class RetryHeaderUtils {
    public static boolean tryDetermineRetryDelay(HttpResponse httpResponse, OutParameter<Duration> result) {
        try {
            return RetryHeaderUtils.internalTryDetermineRetryDelay(httpResponse, result);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean internalTryDetermineRetryDelay(HttpResponse httpResponse, OutParameter<Duration> result) {
        Header retryAfterHeader = httpResponse.getFirstHeader("Retry-After");
        if (retryAfterHeader == null) {
            return false;
        }
        String retryDelayAsString = retryAfterHeader.getValue();
        if (StringUtils.isNullOrWhiteSpace(retryDelayAsString)) {
            return false;
        }
        if (RetryHeaderUtils.tryGetFromLong(retryDelayAsString, result)) {
            return true;
        }
        return RetryHeaderUtils.tryGetFromDate(retryDelayAsString, result);
    }

    private static boolean tryGetFromLong(String retryDelayAsString, OutParameter<Duration> result) {
        OutParameter<Long> longResult = new OutParameter<Long>();
        if (!RetryHeaderUtils.tryConvertToLong(retryDelayAsString, longResult)) {
            return false;
        }
        Duration retryDelayAsDuration = Duration.ofSeconds(longResult.get());
        result.set(retryDelayAsDuration);
        return true;
    }

    private static boolean tryConvertToLong(String longAsString, OutParameter<Long> result) {
        try {
            result.set(Long.parseLong(longAsString));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean tryGetFromDate(String dateAsString, OutParameter<Duration> result) {
        ZonedDateTime nextRetryDateTime;
        OutParameter<ZonedDateTime> resultDate = new OutParameter<ZonedDateTime>();
        if (!RetryHeaderUtils.tryToConvertToDate(dateAsString, resultDate)) {
            return false;
        }
        ZonedDateTime utcNowDateTime = DateUtils.getUtcNow();
        Duration durationToNextRetryTime = Duration.between(utcNowDateTime, nextRetryDateTime = resultDate.get().withZoneSameInstant(ZoneOffset.UTC));
        if (durationToNextRetryTime.getSeconds() < 0L) {
            durationToNextRetryTime = Duration.ofSeconds(0L);
        }
        result.set(durationToNextRetryTime);
        return true;
    }

    private static boolean tryToConvertToDate(String dateAsString, OutParameter<ZonedDateTime> result) {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.RFC_1123_DATE_TIME;
            result.set(ZonedDateTime.parse(dateAsString, formatter));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

