/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.sqlmapper.mapping;

import de.bytefish.sqlmapper.handlers.IValueHandler;
import de.bytefish.sqlmapper.mapping.IPropertyMapping;
import java.sql.ResultSet;
import java.util.function.BiConsumer;

public class PropertyMapping<TEntity, TProperty>
implements IPropertyMapping<TEntity> {
    private String columnName;
    private BiConsumer<TEntity, TProperty> setter;
    private IValueHandler<TProperty> handler;

    public PropertyMapping(String columnName, BiConsumer<TEntity, TProperty> setter, IValueHandler<TProperty> handler) {
        this.columnName = columnName;
        this.setter = setter;
        this.handler = handler;
    }

    @Override
    public void map(TEntity entity, ResultSet resultSet) {
        TProperty value = this.handler.handle(this.columnName, resultSet);
        this.setter.accept(entity, value);
    }
}

