/*
 * Decompiled with CFR 0.152.
 */
package de.carne.boot;

import de.carne.boot.ApplicationInitializationException;
import de.carne.boot.ApplicationJarClassLoader;
import de.carne.boot.ApplicationMain;
import de.carne.boot.InstanceHolder;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;

public final class Application {
    private static final boolean DEBUG = Boolean.getBoolean(Application.class.getName() + ".debug");
    private static final InstanceHolder<ApplicationMain> APPLICATION_MAIN = new InstanceHolder();

    private Application() {
    }

    private static String debug(String format, Object ... args) {
        String msg = String.format(format, args);
        System.out.println(msg);
        return msg;
    }

    private static String error(@Nullable Throwable thrown, String format, Object ... args) {
        String msg = String.format(format, args);
        System.err.println(msg);
        if (thrown != null) {
            thrown.printStackTrace(System.err);
        }
        return msg;
    }

    public static void main(String[] args) {
        int status = -1;
        try {
            if (DEBUG) {
                Application.debug("VM/Version: " + System.getProperty("java.vm.name") + "/" + System.getProperty("java.version"), new Object[0]);
                Application.debug("Booting application...", new Object[0]);
            }
            status = APPLICATION_MAIN.set(Application.setupApplication()).run(args);
            if (DEBUG) {
                Application.debug("Application finished with status: %1$d", status);
            }
        }
        catch (RuntimeException e) {
            Application.error(e, "Application failed with exception: %1$s", e.getClass().getTypeName());
        }
        if (status != 0) {
            System.exit(status);
        }
    }

    public static int run(String[] args) {
        int status = -1;
        if (DEBUG) {
            Application.debug("Running application...", new Object[0]);
        }
        status = APPLICATION_MAIN.set(Application.setupApplication()).run(args);
        if (DEBUG) {
            Application.debug("Application finished with status: %1$d", status);
        }
        return status;
    }

    private static ApplicationMain setupApplication() {
        ApplicationMain applicationMain;
        String applicationMainName;
        Enumeration<URL> configUrls;
        ClassLoader applicationClassLoader = Application.setupApplicationClassLoader();
        String configName = Application.getApplicationConfigName();
        if (DEBUG) {
            Application.debug("Using application configuration: %1$s", configName);
        }
        try {
            configUrls = applicationClassLoader.getResources(configName);
        }
        catch (IOException e) {
            throw new ApplicationInitializationException(Application.error(e, "Failed to locate application configuration: %1$s", configName));
        }
        if (!configUrls.hasMoreElements()) {
            throw new ApplicationInitializationException(Application.error(null, "Failed to locate application configuration: %1$s", configName));
        }
        URL configUrl = configUrls.nextElement();
        if (configUrls.hasMoreElements()) {
            StringBuilder configUrlsString = new StringBuilder();
            configUrlsString.append(configUrl.toExternalForm());
            do {
                URL extraConfigUrl = configUrls.nextElement();
                configUrlsString.append(System.lineSeparator()).append('\t').append(extraConfigUrl.toExternalForm());
            } while (configUrls.hasMoreElements());
            throw new ApplicationInitializationException(Application.error(null, "Found multiple application configurations: %1$s", configUrlsString));
        }
        if (DEBUG) {
            Application.debug("Found application configuration: %1$s", configUrl.toExternalForm());
        }
        try (BufferedReader configReader = new BufferedReader(new InputStreamReader(configUrl.openStream()));){
            String propertyLine;
            applicationMainName = configReader.readLine();
            if (applicationMainName == null) {
                throw new EOFException(Application.error(null, "Empty application configuration: %1$s", configUrl.toExternalForm()));
            }
            if (DEBUG) {
                Application.debug("Using application main class: %1$s", applicationMainName);
                Application.debug("Applying system properties:", new Object[0]);
            }
            System.setProperty("java.util.logging.config.file", "logging-boot.properties");
            while ((propertyLine = configReader.readLine()) != null) {
                Application.evalConfigProperty(propertyLine);
            }
        }
        catch (IOException e) {
            throw new ApplicationInitializationException(Application.error(e, "Failed to read application configuration: %1$s", configName), e);
        }
        if (DEBUG) {
            Application.debug("Loading & instantiating application main class: %1$s", applicationMainName);
        }
        try {
            applicationMain = Class.forName(applicationMainName, true, applicationClassLoader).asSubclass(ApplicationMain.class).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new ApplicationInitializationException(Application.error(e, "Failed to load & instantiate application main class: %1$s", applicationMainName), e);
        }
        return applicationMain;
    }

    private static String getApplicationConfigName() {
        StringBuilder configName = new StringBuilder();
        configName.append("META-INF/").append(Application.class.getName());
        String configNameSuffix = System.getProperty(Application.class.getName());
        if (configNameSuffix != null && !configNameSuffix.isEmpty()) {
            configName.append('.').append(configNameSuffix);
        }
        return configName.toString();
    }

    private static void evalConfigProperty(String propertyLine) {
        String trimmedPropertyLine = propertyLine.trim();
        if (DEBUG) {
            Application.debug(" %1$s", trimmedPropertyLine);
        }
        if (trimmedPropertyLine.length() > 0 && !trimmedPropertyLine.startsWith("#")) {
            int splitIndex = trimmedPropertyLine.indexOf(61);
            if (splitIndex < 0) {
                System.setProperty(trimmedPropertyLine, Boolean.TRUE.toString());
            } else if (splitIndex > 0) {
                String key = trimmedPropertyLine.substring(0, splitIndex).trim();
                String value = trimmedPropertyLine.substring(splitIndex + 1).trim();
                System.setProperty(key, value);
            } else {
                Application.error(null, "Ignoring invalid system property configuration: %1$s", propertyLine);
            }
        }
    }

    private static ClassLoader setupApplicationClassLoader() {
        URL codeLocation = Application.class.getResource(Application.class.getSimpleName() + ".class");
        if (DEBUG) {
            Application.debug("Code location: %1$s", codeLocation.toExternalForm());
        }
        String codeLocationProtocol = codeLocation.getProtocol();
        ClassLoader bootstrapClassLoader = Thread.currentThread().getContextClassLoader();
        if (bootstrapClassLoader == null) {
            bootstrapClassLoader = Application.class.getClassLoader();
        }
        Objects.requireNonNull(bootstrapClassLoader);
        ClassLoader applicationClassLoader = null;
        if ("jar".equals(codeLocationProtocol)) {
            try {
                JarURLConnection jarConnection = (JarURLConnection)codeLocation.openConnection();
                applicationClassLoader = new ApplicationJarClassLoader(jarConnection, bootstrapClassLoader);
            }
            catch (IOException e) {
                throw new ApplicationInitializationException(Application.error(e, "Failed to access application jar via configuration: %1$s", codeLocation.toExternalForm()), e);
            }
            if (DEBUG) {
                Application.debug("Class-Path:", new Object[0]);
                for (URL url : ((URLClassLoader)applicationClassLoader).getURLs()) {
                    Application.debug(" %1$s", url.toExternalForm());
                }
            }
            Thread.currentThread().setContextClassLoader(applicationClassLoader);
        }
        return applicationClassLoader != null ? applicationClassLoader : bootstrapClassLoader;
    }

    public static <T extends ApplicationMain> T getMain(Class<T> clazz) {
        return (T)((ApplicationMain)clazz.cast(APPLICATION_MAIN.get()));
    }
}

