/*
 * Decompiled with CFR 0.152.
 */
package de.carne.boot;

import de.carne.boot.ApplicationURLStreamHandlerFactories;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jdt.annotation.Nullable;

final class ApplicationJarURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static final String PROTOCOL_PREFIX = "jarjar";
    private static final AtomicInteger PROTOCOL_INDEX = new AtomicInteger();
    private final String protocol = "jarjar" + PROTOCOL_INDEX.getAndIncrement();
    private final ClassLoader resourceLoader;

    public ApplicationJarURLStreamHandlerFactory(ClassLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        ApplicationURLStreamHandlerFactories.register(this.protocol, this);
    }

    public URL getJarJarUrl(String jarJar) throws MalformedURLException {
        return new URL("jar:" + this.protocol + ":" + jarJar + "!/");
    }

    public ClassLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Override
    public URLStreamHandler createURLStreamHandler(@Nullable String p) {
        return new URLStreamHandler(){

            @Override
            protected @Nullable URLConnection openConnection(@Nullable URL u) throws IOException {
                return u != null ? new URLConnection(u){

                    @Override
                    public void connect() throws IOException {
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        String fileResource = this.getURL().getFile();
                        InputStream fileResourceStream = ApplicationJarURLStreamHandlerFactory.this.getResourceLoader().getResourceAsStream(fileResource);
                        if (fileResourceStream == null) {
                            throw new FileNotFoundException("Unknown file resource: " + fileResource);
                        }
                        return fileResourceStream;
                    }
                } : null;
            }
        };
    }
}

