/*
 * Decompiled with CFR 0.152.
 */
package de.carne.boot;

import java.util.LinkedList;
import java.util.List;

public final class ShutdownHooks {
    private static final boolean DEBUG = Boolean.getBoolean(ShutdownHooks.class.getName() + ".debug");
    private static final List<Runnable> HOOKS = new LinkedList<Runnable>();

    private ShutdownHooks() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(Runnable hook) {
        List<Runnable> list = HOOKS;
        synchronized (list) {
            HOOKS.add(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void trigger() {
        List<Runnable> list = HOOKS;
        synchronized (list) {
            for (Runnable hook : HOOKS) {
                try {
                    hook.run();
                }
                catch (Exception e) {
                    if (!DEBUG) continue;
                    e.printStackTrace();
                }
            }
        }
    }

    static {
        Thread shutdownHook = new Thread(ShutdownHooks::trigger, ShutdownHooks.class.getSimpleName());
        shutdownHook.setDaemon(true);
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }
}

