/*
 * Decompiled with CFR 0.152.
 */
package de.carne.io;

import de.carne.io.Checksum;
import de.carne.io.Defaults;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jdt.annotation.Nullable;

public class ChecksumInputStream
extends FilterInputStream {
    private final Checksum checksum;

    public ChecksumInputStream(InputStream in, Checksum checksum) {
        super(in);
        this.checksum = checksum;
    }

    public byte[] getChecksumValue() {
        return this.checksum.getValue();
    }

    @Override
    public int read() throws IOException {
        int read = this.in.read();
        if (read >= 0) {
            this.checksum.update((byte)read);
        }
        return read;
    }

    @Override
    public int read(byte @Nullable [] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte @Nullable [] b, int off, int len) throws IOException {
        int read = this.in.read(b, off, len);
        if (read > 0) {
            this.checksum.update(b, off, read);
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        long totalRead;
        int read;
        byte[] buffer = new byte[Defaults.DEFAULT_BUFFER_SIZE];
        for (totalRead = 0L; totalRead < n && (read = this.read(buffer)) >= 0; totalRead += (long)read) {
        }
        return totalRead;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

