/*
 * Decompiled with CFR 0.152.
 */
package de.carne.text;

import de.carne.text.Parser;

public class IntegerParser
implements Parser<Integer> {
    public static final IntegerParser ANY = new IntegerParser();
    public static final IntegerParser POSITIVE = new IntegerParser(0, Integer.MAX_VALUE);
    private final int min;
    private final int max;

    public IntegerParser() {
        this(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntegerParser(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public Integer parse(String s) {
        return this.parseInt(s);
    }

    public int parseInt(String s) {
        int i = Integer.parseInt(s);
        if (i < this.min || this.max < i) {
            throw new IllegalArgumentException("Integer value " + i + " out of range [" + this.min + ", " + this.max + "]");
        }
        return i;
    }
}

