/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util;

import de.carne.util.Exceptions;
import org.eclipse.jdt.annotation.Nullable;

public final class AutoCloseables {
    private AutoCloseables() {
    }

    public static void close(@Nullable Object object) throws Exception {
        if (object instanceof AutoCloseable) {
            ((AutoCloseable)object).close();
        }
    }

    public static void closeAll(AutoCloseable ... closeables) throws Exception {
        Exception exception = null;
        for (AutoCloseable closable : closeables) {
            if (closable == null) continue;
            try {
                closable.close();
            }
            catch (Exception e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static void closeAll(Iterable<AutoCloseable> closeables) throws Exception {
        Exception exception = null;
        for (AutoCloseable closable : closeables) {
            try {
                closable.close();
            }
            catch (Exception e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static void safeClose(@Nullable Object object) {
        if (object instanceof AutoCloseable) {
            try {
                ((AutoCloseable)object).close();
            }
            catch (Exception e) {
                Exceptions.ignore(e);
            }
        }
    }

    public static void safeClose(Throwable exception, @Nullable Object object) {
        if (object instanceof AutoCloseable) {
            try {
                ((AutoCloseable)object).close();
            }
            catch (Exception e) {
                exception.addSuppressed(e);
            }
        }
    }
}

