/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.logging;

import de.carne.util.logging.Logs;
import java.io.Console;
import java.io.PrintWriter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class ConsoleHandler
extends StreamHandler {
    private final boolean consoleOnly;

    public ConsoleHandler() {
        LogManager manager = LogManager.getLogManager();
        String propertyBase = this.getClass().getName();
        this.consoleOnly = Logs.getBooleanProperty(manager, propertyBase + ".consoleOnly", false);
        this.setOutputStream(System.out);
    }

    @Override
    public synchronized void publish(LogRecord record) {
        Console console = System.console();
        if (console != null) {
            if (this.isLoggable(record)) {
                this.publishToConsole(console, record, true);
            }
        } else if (!this.consoleOnly) {
            super.publish(record);
            super.flush();
        }
    }

    private void publishToConsole(Console console, LogRecord record, boolean flush) {
        String message = null;
        try {
            message = this.getFormatter().format(record);
        }
        catch (Exception e) {
            this.reportError(null, e, 5);
        }
        if (message != null) {
            PrintWriter writer = console.writer();
            try {
                writer.write(message);
                if (flush) {
                    writer.flush();
                }
            }
            catch (Exception e) {
                this.reportError(null, e, 1);
            }
        }
    }

    @Override
    public synchronized void flush() {
        Console console = System.console();
        if (console != null) {
            try {
                console.flush();
            }
            catch (Exception e) {
                this.reportError(null, e, 2);
            }
        } else {
            super.flush();
        }
    }

    @Override
    public synchronized void close() {
        this.flush();
    }
}

