/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.logging;

import de.carne.util.logging.LogLevel;
import de.carne.util.logging.Logs;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.Nullable;

public final class Log {
    private final Logger logger;
    private static final AtomicReference<@Nullable Log> rootHolder;

    public Log() {
        this(Logger.getLogger(Log.getCallerClassName()));
    }

    public Log(String resourceBundleName) {
        this(Logger.getLogger(Log.getCallerClassName(), resourceBundleName));
    }

    public Log(Class<?> clazz) {
        this(Logger.getLogger(clazz.getName()));
    }

    public Log(Class<?> clazz, String resourceBundleName) {
        this(Logger.getLogger(clazz.getName(), resourceBundleName));
    }

    private Log(Logger logger) {
        this.logger = logger;
    }

    public static Log root() {
        return rootHolder.updateAndGet(rootLog -> rootLog != null ? rootLog : new Log(Logger.getLogger("")));
    }

    public Logger logger() {
        return this.logger;
    }

    public boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }

    public void log(Level level, @Nullable Throwable thrown, String msg, Object ... parameters) {
        if (this.logger.isLoggable(level)) {
            this.logger.log(level, thrown, () -> MessageFormat.format(msg, parameters));
        }
    }

    public boolean isNoticeLoggable() {
        return this.isLoggable(LogLevel.LEVEL_NOTICE);
    }

    public void notice(String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_NOTICE, null, msg, parameters);
    }

    public void notice(Throwable thrown, String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_NOTICE, thrown, msg, parameters);
    }

    public boolean isErrorLoggable() {
        return this.isLoggable(LogLevel.LEVEL_ERROR);
    }

    public void error(String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_ERROR, null, msg, parameters);
    }

    public void error(Throwable thrown, String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_ERROR, thrown, msg, parameters);
    }

    public boolean isWarningLoggable() {
        return this.isLoggable(LogLevel.LEVEL_WARNING);
    }

    public void warning(String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_WARNING, null, msg, parameters);
    }

    public void warning(Throwable thrown, String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_WARNING, thrown, msg, parameters);
    }

    public boolean isInfoLoggable() {
        return this.isLoggable(LogLevel.LEVEL_INFO);
    }

    public void info(String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_INFO, null, msg, parameters);
    }

    public void info(Throwable thrown, String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_INFO, thrown, msg, parameters);
    }

    public boolean isDebugLoggable() {
        return this.isLoggable(LogLevel.LEVEL_DEBUG);
    }

    public void debug(String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_DEBUG, null, msg, parameters);
    }

    public void debug(Throwable thrown, String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_DEBUG, thrown, msg, parameters);
    }

    public boolean isTraceLoggable() {
        return this.isLoggable(LogLevel.LEVEL_TRACE);
    }

    public void trace(String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_TRACE, null, msg, parameters);
    }

    public void trace(Throwable thrown, String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_TRACE, thrown, msg, parameters);
    }

    private static String getCallerClassName() {
        int steIndex;
        StackTraceElement[] stes = Thread.currentThread().getStackTrace();
        String myClassName = Log.class.getName();
        for (steIndex = 0; steIndex < stes.length && !myClassName.equals(stes[steIndex].getClassName()); ++steIndex) {
        }
        while (steIndex < stes.length && myClassName.equals(stes[steIndex].getClassName())) {
            ++steIndex;
        }
        return steIndex < stes.length ? stes[steIndex].getClassName() : myClassName;
    }

    public String toString() {
        return Objects.toString(this.logger.getName());
    }

    static {
        Logs.initialize();
        rootHolder = new AtomicReference();
    }
}

