/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.logging;

import de.carne.util.logging.Log;
import de.carne.util.logging.LogLevel;
import de.carne.util.logging.LogLineFormatter;
import de.carne.util.logging.Logs;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.Nullable;

public class LogBuffer
extends Handler {
    private final int limit;
    private final Queue<LogRecord> buffer;
    private final Set<Handler> handlers = new HashSet<Handler>();
    private final AtomicBoolean locked = new AtomicBoolean();

    public LogBuffer() {
        LogManager manager = LogManager.getLogManager();
        String propertyBase = this.getClass().getName();
        this.limit = Logs.getIntProperty(manager, propertyBase + ".limit", 1000);
        this.buffer = new ArrayDeque<LogRecord>(this.limit);
        this.setLevel(Logs.getLevelProperty(manager, propertyBase + ".level", LogLevel.LEVEL_WARNING));
        this.setFilter(Logs.getFilterProperty(manager, propertyBase + ".filter", null));
    }

    public static @Nullable LogBuffer get(Log log) {
        return LogBuffer.get(log.logger());
    }

    public static @Nullable LogBuffer get(Logger logger) {
        LogBuffer logBuffer = null;
        block0: for (Logger currentLogger = logger; logBuffer == null && currentLogger != null; currentLogger = currentLogger.getParent()) {
            for (Handler handler : currentLogger.getHandlers()) {
                if (!(handler instanceof LogBuffer)) continue;
                logBuffer = (LogBuffer)handler;
                continue block0;
            }
        }
        return logBuffer;
    }

    public static void addHandler(Log log, Handler handler, boolean republishBuffer) {
        LogBuffer.addHandler(log.logger(), handler, republishBuffer);
    }

    public static void addHandler(Logger logger, Handler handler, boolean republishBuffer) {
        LogBuffer logBuffer = LogBuffer.get(logger);
        if (logBuffer != null) {
            logBuffer.addHandler(handler, republishBuffer);
        }
    }

    public synchronized void addHandler(Handler handler, boolean republishBuffer) {
        for (LogRecord record : this.buffer) {
            handler.publish(record);
        }
        this.handlers.add(handler);
    }

    public static <T extends Handler> @Nullable T getHandler(Log log, Class<T> handlerType) {
        return LogBuffer.getHandler(log.logger(), handlerType);
    }

    public static <T extends Handler> @Nullable T getHandler(Logger logger, Class<T> handlerType) {
        LogBuffer logBuffer = LogBuffer.get(logger);
        return logBuffer != null ? (T)logBuffer.getHandler(handlerType) : null;
    }

    public synchronized <T extends Handler> @Nullable T getHandler(Class<T> handlerType) {
        @Nullable Handler found = null;
        for (Handler handler : this.handlers) {
            if (!handler.getClass().equals(handlerType)) continue;
            found = (Handler)handlerType.cast(handler);
            break;
        }
        return (T)found;
    }

    public static void removeHandler(Log log, Handler handler) {
        LogBuffer.removeHandler(log.logger(), handler);
    }

    public static void removeHandler(Logger logger, Handler handler) {
        LogBuffer logBuffer = LogBuffer.get(logger);
        if (logBuffer != null) {
            logBuffer.removeHandler(handler);
        }
    }

    public synchronized void removeHandler(Handler handler) {
        this.handlers.remove(handler);
    }

    public static void exportTo(Log log, File file, boolean append) throws IOException {
        LogBuffer.exportTo(log.logger(), file, append);
    }

    public static void exportTo(Logger logger, File file, boolean append) throws IOException {
        LogBuffer logBuffer = LogBuffer.get(logger);
        if (logBuffer != null) {
            logBuffer.exportTo(file, append);
        }
    }

    public synchronized void exportTo(File file, boolean append) throws IOException {
        try (FileWriter writer = new FileWriter(file, append);){
            LogLineFormatter formatter = new LogLineFormatter();
            for (LogRecord record : this.buffer) {
                writer.write(formatter.format(record));
            }
        }
    }

    public static void flush(Log log) {
        LogBuffer.flush(log.logger());
    }

    public static void flush(Logger logger) {
        LogBuffer logBuffer = LogBuffer.get(logger);
        if (logBuffer != null) {
            logBuffer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(@Nullable LogRecord record) {
        if (record != null && this.isLoggable(record) && this.locked.compareAndSet(false, true)) {
            try {
                LogBuffer logBuffer = this;
                synchronized (logBuffer) {
                    while (this.buffer.size() >= this.limit) {
                        this.buffer.remove();
                    }
                    this.buffer.add(record);
                    this.handlers.forEach(handler -> handler.publish(record));
                }
            }
            finally {
                this.locked.set(false);
            }
        }
    }

    @Override
    public synchronized void flush() {
        this.handlers.forEach(Handler::flush);
        this.buffer.clear();
    }

    @Override
    public synchronized void close() {
        this.handlers.forEach(Handler::close);
        this.handlers.clear();
    }
}

