/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.logging;

import de.carne.util.logging.Logs;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.eclipse.jdt.annotation.Nullable;

public class LogLineFormatter
extends Formatter {
    public static final DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss,SSS");

    @Override
    public String format(@Nullable LogRecord record) {
        String message = null;
        if (record != null) {
            try (StringWriter sw = new StringWriter();
                 PrintWriter pw = new PrintWriter(sw);){
                pw.print(this.formatMillis(record));
                pw.print(" [");
                pw.print(record.getThreadID());
                pw.print("] ");
                pw.print(record.getLevel());
                pw.print(" ");
                pw.print(record.getLoggerName());
                pw.print(": ");
                pw.println(this.formatMessage(record));
                Throwable thrown = record.getThrown();
                if (thrown != null) {
                    thrown.printStackTrace(pw);
                }
                pw.flush();
                message = sw.toString();
            }
            catch (Exception e) {
                Logs.DEFAULT_ERROR_MANAGER.error("Failed to format log record", e, 5);
            }
        }
        return message != null ? message : "...";
    }

    public String formatMillis(LogRecord record) {
        LocalDateTime recordTimestamp = LocalDateTime.ofInstant(Instant.ofEpochMilli(record.getMillis()), ZoneId.systemDefault());
        return DATE_TIME_FORMAT.format(recordTimestamp);
    }
}

