/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.logging;

import de.carne.util.logging.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.Nullable;

public final class LogRecorder {
    private final List<Predicate<LogRecord>> includeRecords = new ArrayList<Predicate<LogRecord>>();
    private final List<Predicate<LogRecord>> excludeRecords = new ArrayList<Predicate<LogRecord>>();
    private final List<Logger> loggers = new ArrayList<Logger>();

    public LogRecorder(Level level) {
        this.excludeRecord(record -> record.getLevel().intValue() < level.intValue());
    }

    public LogRecorder includeRecord(Predicate<LogRecord> include) {
        this.includeRecords.add(include);
        return this;
    }

    public LogRecorder excludeRecord(Predicate<LogRecord> exclude) {
        this.excludeRecords.add(exclude);
        return this;
    }

    public LogRecorder addLog(Log log) {
        return this.addLogger(log.logger());
    }

    public LogRecorder addLogger(Logger logger) {
        this.loggers.add(logger);
        return this;
    }

    public Session start(boolean currentThreadOnly) {
        return new Session(currentThreadOnly);
    }

    void startSession(Session session) {
        this.loggers.stream().forEach(logger -> logger.addHandler(session));
    }

    void stopSession(Session session) {
        this.loggers.stream().forEach(logger -> logger.removeHandler(session));
    }

    boolean testRecord(LogRecord record) {
        return this.excludeRecords.stream().noneMatch(exclude -> exclude.test(record)) && (this.includeRecords.isEmpty() || this.includeRecords.stream().anyMatch(include -> include.test(record)));
    }

    public class Session
    extends Handler
    implements AutoCloseable {
        private final List<Predicate<Thread>> includeThreads = new ArrayList<Predicate<Thread>>();
        private final List<Predicate<Thread>> excludeThreads = new ArrayList<Predicate<Thread>>();
        private final Queue<LogRecord> buffer = new ConcurrentLinkedQueue<LogRecord>();
        private final AtomicBoolean locked = new AtomicBoolean();

        Session(boolean currentThreadOnly) {
            if (currentThreadOnly) {
                Thread currentThread = Thread.currentThread();
                this.excludeThread(thread -> !thread.equals(currentThread));
            }
            LogRecorder.this.startSession(this);
        }

        public Session includeThread(Predicate<Thread> include) {
            this.includeThreads.add(include);
            return this;
        }

        public Session excludeThread(Predicate<Thread> exclude) {
            this.excludeThreads.add(exclude);
            return this;
        }

        public Collection<LogRecord> getRecords() {
            return Collections.unmodifiableCollection(this.buffer);
        }

        private boolean testThread(Thread thread) {
            return this.excludeThreads.stream().noneMatch(exclude -> exclude.test(thread)) && (this.includeThreads.isEmpty() || this.includeThreads.stream().anyMatch(include -> include.test(thread)));
        }

        @Override
        public void publish(@Nullable LogRecord record) {
            if (record != null && this.locked.compareAndSet(false, true) && this.testThread(Thread.currentThread()) && LogRecorder.this.testRecord(record)) {
                this.buffer.add(record);
                this.locked.set(false);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
            LogRecorder.this.stopSession(this);
        }
    }
}

