/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.logging;

import de.carne.util.logging.Logs;
import de.carne.util.logging.proxy.AutoProxy;
import de.carne.util.logging.proxy.Log4j2Proxy;
import de.carne.util.logging.proxy.Proxy;
import de.carne.util.logging.proxy.Slf4jProxy;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.eclipse.jdt.annotation.Nullable;

public class ProxyHandler
extends Handler {
    private static final Formatter DEFAULT_FORMATTER = new Formatter(){

        @Override
        public String format(@Nullable LogRecord record) {
            return this.formatMessage(record);
        }
    };
    private final Proxy proxy;

    public ProxyHandler() {
        LogManager manager = LogManager.getLogManager();
        String propertyBase = this.getClass().getName();
        Type type = ProxyHandler.getTypeProperty(manager, propertyBase + ".type", Type.AUTO);
        this.proxy = ProxyHandler.getProxyInstance(type.proxyClass());
    }

    @Override
    public void publish(@Nullable LogRecord record) {
        if (record != null) {
            Formatter formatter = this.getFormatter();
            this.proxy.publish(record, formatter != null ? formatter : DEFAULT_FORMATTER);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    private static Type getTypeProperty(LogManager manager, String name, Type defaultValue) {
        String typeName = Logs.getStringProperty(manager, name, defaultValue.name());
        Type type = defaultValue;
        try {
            type = Type.valueOf(typeName);
        }
        catch (IllegalArgumentException e) {
            Logs.DEFAULT_ERROR_MANAGER.error("Invalid type property " + name, e, 0);
        }
        return type;
    }

    private static Proxy getProxyInstance(Class<? extends Proxy> proxyClass) {
        Proxy proxy;
        try {
            proxy = proxyClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            Logs.DEFAULT_ERROR_MANAGER.error("Failed to instanticate proxy class " + proxyClass.getName(), e, 0);
            proxy = new AutoProxy();
        }
        return proxy;
    }

    private static enum Type {
        AUTO(AutoProxy.class),
        LOG4J2(Log4j2Proxy.class),
        SLF4J(Slf4jProxy.class);

        private final Class<? extends Proxy> proxyClass;

        private Type(Class<? extends Proxy> proxyClass) {
            this.proxyClass = proxyClass;
        }

        public Class<? extends Proxy> proxyClass() {
            return this.proxyClass;
        }
    }
}

