/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.logging.proxy;

import de.carne.util.logging.LogLevel;
import de.carne.util.logging.ProxyHandler;
import de.carne.util.logging.proxy.Proxy;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class Slf4jProxy
implements Proxy {
    private final Logger logger = LoggerFactory.getLogger(ProxyHandler.class);

    @Override
    public void publish(LogRecord logRecord, Formatter formatter) {
        int levelValue = logRecord.getLevel().intValue();
        if (levelValue <= LogLevel.LEVEL_TRACE.intValue()) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(MarkerFactory.getMarker((String)logRecord.getLoggerName()), formatter.format(logRecord), logRecord.getThrown());
            }
        } else if (levelValue <= LogLevel.LEVEL_DEBUG.intValue()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(MarkerFactory.getMarker((String)logRecord.getLoggerName()), formatter.format(logRecord), logRecord.getThrown());
            }
        } else if (levelValue <= LogLevel.LEVEL_INFO.intValue()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(MarkerFactory.getMarker((String)logRecord.getLoggerName()), formatter.format(logRecord), logRecord.getThrown());
            }
        } else if (levelValue <= LogLevel.LEVEL_WARNING.intValue()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(MarkerFactory.getMarker((String)logRecord.getLoggerName()), formatter.format(logRecord), logRecord.getThrown());
            }
        } else if (this.logger.isErrorEnabled()) {
            this.logger.error(MarkerFactory.getMarker((String)logRecord.getLoggerName()), formatter.format(logRecord), logRecord.getThrown());
        }
    }
}

