/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.prefs;

import de.carne.util.Exceptions;
import de.carne.util.logging.Log;
import de.carne.util.prefs.FilePreferences;
import de.carne.util.prefs.FilePreferencesStore;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.prefs.Preferences;
import java.util.prefs.PreferencesFactory;
import org.eclipse.jdt.annotation.Nullable;

public class FilePreferencesFactory
implements PreferencesFactory {
    private static final Log LOG = new Log();
    private static final String PROPERTY_STORE_HOME = FilePreferences.class.getName();
    private static final @Nullable String STORE_HOME = System.getProperty(PROPERTY_STORE_HOME);

    @Override
    public Preferences systemRoot() {
        FilePreferencesStore store;
        if (STORE_HOME != null) {
            store = FilePreferencesStore.fromFile(FilePreferencesFactory.systemRootFile());
        } else {
            LOG.debug("Store home property {0} not set; using transient store", PROPERTY_STORE_HOME);
            store = FilePreferencesStore.fromData(new Properties());
        }
        return store.root();
    }

    @Override
    public Preferences userRoot() {
        FilePreferencesStore store;
        if (STORE_HOME != null) {
            store = FilePreferencesStore.fromFile(FilePreferencesFactory.userRootFile());
        } else {
            LOG.debug("Store home property {0} not set; using transient store", PROPERTY_STORE_HOME);
            store = FilePreferencesStore.fromData(new Properties());
        }
        return store.root();
    }

    public static Path systemRootFile() {
        String systemName = FilePreferencesFactory.getSystemName();
        return FilePreferencesFactory.customRootFile("system." + systemName + ".conf");
    }

    public static Path userRootFile() {
        return FilePreferencesFactory.customRootFile("user.conf");
    }

    public static Path customRootFile(String name) {
        return FilePreferencesFactory.resolveStoreHomeFile(name);
    }

    public static Preferences customRoot(Path file) {
        return FilePreferencesStore.fromFile(file).root();
    }

    public static Preferences customRoot(File file) {
        return FilePreferencesFactory.customRoot(file.toPath());
    }

    public static Preferences customRoot(Properties data) {
        return FilePreferencesStore.fromData(data).root();
    }

    public static void flush() {
        FilePreferencesStore.flushFileStores();
    }

    private static Path resolveStoreHomeFile(String name) {
        Path userHome = Paths.get(System.getProperty("user.home", "."), new String[0]);
        Path storeHome = userHome.resolve((String)(STORE_HOME != null ? STORE_HOME : "." + FilePreferencesFactory.class.getPackage().getName()));
        return storeHome.resolve(name);
    }

    private static String getSystemName() {
        String systemName;
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            int domainIndex = hostname.indexOf(46);
            systemName = domainIndex > 0 ? hostname.substring(0, domainIndex) : hostname;
        }
        catch (UnknownHostException e) {
            Exceptions.ignore(e);
            systemName = "localhost";
        }
        return systemName;
    }
}

