/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.prefs;

import de.carne.util.Exceptions;
import de.carne.util.prefs.FilePreferencesStore;
import de.carne.util.prefs.UserFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.Nullable;

class FileStore
extends FilePreferencesStore {
    private final Path file;

    FileStore(Path file) {
        this.file = file;
    }

    @Override
    protected Properties loadData() throws IOException {
        Properties data = new Properties();
        try (FileChannel dataChannel = FileChannel.open(this.file, StandardOpenOption.READ);
             InputStream dataInputStream = Channels.newInputStream(dataChannel);
             FileLock dataLock = dataChannel.tryLock(0L, Long.MAX_VALUE, true);){
            if (dataLock == null) {
                throw new IOException("Failed to obtain read lock for file: '" + this.file + "'");
            }
            data.load(dataInputStream);
        }
        catch (NoSuchFileException e) {
            Exceptions.ignore(e);
        }
        return data;
    }

    @Override
    protected Properties syncData(List<Consumer<Properties>> changes) throws IOException {
        Properties data = new Properties();
        try (FileChannel dataChannel = UserFile.open(this.file, StandardOpenOption.READ, StandardOpenOption.WRITE);
             InputStream dataInputStream = Channels.newInputStream(dataChannel);
             OutputStream dataOutputStream = Channels.newOutputStream(dataChannel);
             FileLock dataLock = dataChannel.tryLock(0L, Long.MAX_VALUE, false);){
            if (dataLock == null) {
                throw new IOException("Failed to obtain write lock for file: '" + this.file + "'");
            }
            data.load(dataInputStream);
            for (Consumer<Properties> change : changes) {
                change.accept(data);
            }
            dataChannel.truncate(0L);
            data.store(dataOutputStream, null);
        }
        return data;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return obj instanceof FileStore && this.file.equals(((FileStore)obj).file);
    }

    public String toString() {
        return Objects.toString(this.file);
    }
}

