/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.prefs;

import de.carne.util.Exceptions;
import de.carne.util.prefs.Preference;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.prefs.Preferences;

public class PathPreference
extends Preference<Path> {
    public PathPreference(String key, Path defaultValue) {
        super(key, defaultValue);
    }

    @Override
    public Path get(Preferences prefs, Path def) {
        String pathString = prefs.get(this.key(), null);
        Path path = def;
        if (pathString != null) {
            try {
                path = Paths.get(pathString, new String[0]);
            }
            catch (InvalidPathException e) {
                Exceptions.ignore(e);
            }
        }
        return path;
    }

    @Override
    public void put(Preferences prefs, Path value) {
        prefs.put(this.key(), value.toString());
    }
}

