/*
 * Decompiled with CFR 0.152.
 */
package de.carne.io;

import de.carne.boot.Exceptions;
import java.io.Closeable;
import java.io.IOException;
import org.eclipse.jdt.annotation.Nullable;

public final class Closeables {
    private Closeables() {
    }

    public static void close(@Nullable Object object) throws IOException {
        if (object instanceof Closeable) {
            ((Closeable)object).close();
        }
    }

    public static void closeAll(Closeable ... closeables) throws IOException {
        IOException exception = null;
        for (Closeable closable : closeables) {
            if (closable == null) continue;
            try {
                closable.close();
            }
            catch (IOException e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static void safeClose(@Nullable Object object) {
        if (object instanceof Closeable) {
            try {
                ((Closeable)object).close();
            }
            catch (IOException e) {
                Exceptions.ignore((Throwable)e);
            }
        }
    }

    public static void safeClose(Throwable exception, @Nullable Object object) {
        if (object instanceof Closeable) {
            try {
                ((Closeable)object).close();
            }
            catch (IOException e) {
                exception.addSuppressed(e);
            }
        }
    }
}

