/*
 * Decompiled with CFR 0.152.
 */
package de.carne.nio.file.attribute;

import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;

public final class FileAttributes {
    private static final String POSIX = "posix";

    private FileAttributes() {
    }

    public static FileAttribute<?>[] userDirectoryDefault(FileSystem fileSystem) {
        ArrayList<FileAttribute<Set<PosixFilePermission>>> userDefault = new ArrayList<FileAttribute<Set<PosixFilePermission>>>();
        Set<String> fileAttributeViews = fileSystem.supportedFileAttributeViews();
        if (fileAttributeViews.contains(POSIX)) {
            userDefault.add(PosixFilePermissions.asFileAttribute(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE)));
        }
        return userDefault.toArray(new FileAttribute[userDefault.size()]);
    }

    public static FileAttribute<?>[] userDirectoryDefault(Path path) {
        return FileAttributes.userDirectoryDefault(path.getFileSystem());
    }

    public static FileAttribute<?>[] userFileDefault(FileSystem fileSystem) {
        ArrayList<FileAttribute<Set<PosixFilePermission>>> userDefault = new ArrayList<FileAttribute<Set<PosixFilePermission>>>();
        Set<String> fileAttributeViews = fileSystem.supportedFileAttributeViews();
        if (fileAttributeViews.contains(POSIX)) {
            userDefault.add(PosixFilePermissions.asFileAttribute(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE)));
        }
        return userDefault.toArray(new FileAttribute[userDefault.size()]);
    }

    public static FileAttribute<?>[] userFileDefault(Path path) {
        return FileAttributes.userFileDefault(path.getFileSystem());
    }
}

