/*
 * Decompiled with CFR 0.152.
 */
package de.carne.text;

public final class HexFormatter {
    private static final char[] UPPER_CASE_HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] LOWER_CASE_HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final char[] hexChars;

    public HexFormatter() {
        this(false);
    }

    public HexFormatter(boolean upperCase) {
        this.hexChars = upperCase ? UPPER_CASE_HEX_CHARS : LOWER_CASE_HEX_CHARS;
    }

    public String format(byte b) {
        return this.format(new StringBuilder(), b).toString();
    }

    public StringBuilder format(StringBuilder buffer, byte b) {
        buffer.append(this.hexChars[b >> 4 & 0xF]);
        buffer.append(this.hexChars[b & 0xF]);
        return buffer;
    }

    public String format(short s) {
        return this.format(new StringBuilder(), s).toString();
    }

    public StringBuilder format(StringBuilder buffer, short s) {
        buffer.append(this.hexChars[s >> 12 & 0xF]);
        buffer.append(this.hexChars[s >> 8 & 0xF]);
        buffer.append(this.hexChars[s >> 4 & 0xF]);
        buffer.append(this.hexChars[s & 0xF]);
        return buffer;
    }

    public String format(int i) {
        return this.format(new StringBuilder(), i).toString();
    }

    public StringBuilder format(StringBuilder buffer, int i) {
        buffer.append(this.hexChars[i >> 28 & 0xF]);
        buffer.append(this.hexChars[i >> 24 & 0xF]);
        buffer.append(this.hexChars[i >> 20 & 0xF]);
        buffer.append(this.hexChars[i >> 16 & 0xF]);
        buffer.append(this.hexChars[i >> 12 & 0xF]);
        buffer.append(this.hexChars[i >> 8 & 0xF]);
        buffer.append(this.hexChars[i >> 4 & 0xF]);
        buffer.append(this.hexChars[i & 0xF]);
        return buffer;
    }

    public String format(long l) {
        return this.format(new StringBuilder(), l).toString();
    }

    public StringBuilder format(StringBuilder buffer, long l) {
        buffer.append(this.hexChars[(int)(l >> 60 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l >> 56 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l >> 52 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l >> 48 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l >> 44 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l >> 40 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l >> 36 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l >> 32 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l >> 28 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l >> 24 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l >> 20 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l >> 16 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l >> 12 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l >> 8 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l >> 4 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l & 0xFL)]);
        return buffer;
    }
}

