/*
 * Decompiled with CFR 0.152.
 */
package de.carne.text;

import de.carne.text.Parser;

public class LongParser
implements Parser<Long> {
    public static final LongParser ANY = new LongParser();
    public static final LongParser POSITIVE = new LongParser(0L, Long.MAX_VALUE);
    private final long min;
    private final long max;

    public LongParser() {
        this(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public LongParser(long min, long max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public Long parse(String s) {
        return this.parseLong(s);
    }

    public long parseLong(String s) {
        long l = Long.parseLong(s);
        if (l < this.min || this.max < l) {
            throw new IllegalArgumentException("Integer value " + l + " out of range [" + this.min + ", " + this.max + "]");
        }
        return l;
    }
}

