/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util;

import de.carne.util.Strings;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class Lazy<@NonNull T>
implements Supplier<T> {
    private final Supplier<T> initializer;
    private @Nullable T object = null;

    public Lazy(Supplier<T> initializer) {
        this.initializer = initializer;
    }

    @Override
    public synchronized T get() {
        @Nullable T checkedObject = this.object;
        if (checkedObject == null) {
            this.object = checkedObject = Objects.requireNonNull(this.initializer.get());
        }
        return checkedObject;
    }

    public Optional<T> getOptional() {
        return Optional.ofNullable(this.object);
    }

    public String toString() {
        return Strings.safe(Objects.toString(this.object, "<not initialized>"));
    }
}

