/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util;

import de.carne.boot.Exceptions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ManifestInfos {
    public static final String ATTRIBUTE_MODULE_NAME = "X-Module-Name";
    public static final String ATTRIBUTE_MODULE_VERSION = "X-Module-Version";
    public static final String ATTRIBUTE_MODULE_BUILD = "X-Module-Build";
    private final String moduleName;
    private final Manifest manifest;

    public ManifestInfos(String moduleName) {
        this.moduleName = moduleName;
        this.manifest = ManifestInfos.findManifest(moduleName);
    }

    public String getMainAttribute(String attributeName, String defaultValue) {
        Attributes attributes = this.manifest.getMainAttributes();
        String attributeValue = attributes != null ? attributes.getValue(attributeName) : null;
        return attributeValue != null ? attributeValue : defaultValue;
    }

    public String name() {
        return this.moduleName;
    }

    public String version() {
        return this.getMainAttribute(ATTRIBUTE_MODULE_VERSION, "n/a");
    }

    public String build() {
        return this.getMainAttribute(ATTRIBUTE_MODULE_BUILD, "n/a");
    }

    private static Manifest findManifest(String moduleName) {
        Manifest found = null;
        try {
            Enumeration<URL> manifestUrls = ManifestInfos.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (manifestUrls.hasMoreElements()) {
                URL manifestUrl = manifestUrls.nextElement();
                InputStream manifestStream = manifestUrl.openStream();
                Throwable throwable = null;
                try {
                    Manifest manifest = new Manifest(manifestStream);
                    Attributes attributes = manifest.getMainAttributes();
                    if (attributes == null || !moduleName.equals(attributes.getValue(ATTRIBUTE_MODULE_NAME))) continue;
                    found = manifest;
                    break;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (manifestStream == null) continue;
                    if (throwable != null) {
                        try {
                            manifestStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    manifestStream.close();
                }
            }
        }
        catch (IOException e) {
            Exceptions.ignore((Throwable)e);
        }
        return found != null ? found : new Manifest();
    }

    public String toString() {
        return this.name() + " " + this.version() + "(build: " + this.build() + ")";
    }
}

