/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util;

import de.carne.boot.logging.Log;
import de.carne.text.IntegerParser;
import de.carne.text.LongParser;

public final class SystemProperties {
    private static final Log LOG = new Log();

    private SystemProperties() {
    }

    public static String value(String key, String defaultValue) {
        return System.getProperty(key, defaultValue);
    }

    public static String value(Class<?> clazz, String key, String defaultValue) {
        return System.getProperty(clazz.getName() + key, defaultValue);
    }

    public static boolean booleanValue(String key) {
        return SystemProperties.booleanValue(key, false);
    }

    public static boolean booleanValue(Class<?> clazz, String key) {
        return SystemProperties.booleanValue(clazz, key, false);
    }

    public static boolean booleanValue(String key, boolean defaultValue) {
        String value = System.getProperty(key);
        boolean booleanValue = defaultValue;
        if (value != null) {
            booleanValue = Boolean.parseBoolean(value);
        }
        return booleanValue;
    }

    public static boolean booleanValue(Class<?> clazz, String key, boolean defaultValue) {
        return SystemProperties.booleanValue(clazz.getName() + key, defaultValue);
    }

    public static int intValue(String key) {
        return SystemProperties.intValue(key, IntegerParser.ANY, 0);
    }

    public static int intValue(Class<?> clazz, String key) {
        return SystemProperties.intValue(clazz, key, IntegerParser.ANY, 0);
    }

    public static int intValue(String key, int defaultValue) {
        return SystemProperties.intValue(key, IntegerParser.ANY, defaultValue);
    }

    public static int intValue(Class<?> clazz, String key, int defaultValue) {
        return SystemProperties.intValue(clazz.getName() + key, IntegerParser.ANY, defaultValue);
    }

    public static int intValue(String key, IntegerParser parser, int defaultValue) {
        String value = System.getProperty(key);
        int intValue = defaultValue;
        if (value != null) {
            try {
                intValue = parser.parseInt(value);
            }
            catch (RuntimeException e) {
                LOG.warning((Throwable)e, "Ignoring invalid int system propert: ''{0}'' = ''{1}''", new Object[]{key, value});
            }
        }
        return intValue;
    }

    public static int intValue(Class<?> clazz, String key, IntegerParser parser, int defaultValue) {
        return SystemProperties.intValue(clazz.getName() + key, parser, defaultValue);
    }

    public static long longValue(String key) {
        return SystemProperties.longValue(key, LongParser.ANY, 0L);
    }

    public static long longValue(Class<?> clazz, String key) {
        return SystemProperties.longValue(clazz, key, LongParser.ANY, 0L);
    }

    public static long longValue(String key, long defaultValue) {
        return SystemProperties.longValue(key, LongParser.ANY, defaultValue);
    }

    public static long longValue(Class<?> clazz, String key, long defaultValue) {
        return SystemProperties.longValue(clazz.getName() + key, LongParser.ANY, defaultValue);
    }

    public static long longValue(String key, LongParser parser, long defaultValue) {
        String value = System.getProperty(key);
        long longValue = defaultValue;
        if (value != null) {
            try {
                longValue = parser.parseLong(value);
            }
            catch (RuntimeException e) {
                LOG.warning((Throwable)e, "Ignoring invalid long system propert: ''{0}'' = ''{1}''", new Object[]{key, value});
            }
        }
        return longValue;
    }

    public static long longValue(Class<?> clazz, String key, LongParser parser, long defaultValue) {
        return SystemProperties.longValue(clazz.getName() + key, parser, defaultValue);
    }
}

