/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.cmdline;

import de.carne.util.cmdline.CmdLineAction;
import de.carne.util.cmdline.CmdLineException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class CmdLineProcessor {
    private static final Pattern ACTION_ARG_PATTERN = Pattern.compile("(-[^-\\s])|(--[^-\\s]+)");
    private final String cmd;
    private final Iterable<@Nullable String> args;
    private final List<@NonNull SwitchCmdLineAction> switchActions = new ArrayList<SwitchCmdLineAction>();
    private final List<@NonNull OptionCmdLineAction> optionActions = new ArrayList<OptionCmdLineAction>();
    private @Nullable Consumer<@NonNull String> unnamedAction = null;
    private @Nullable Consumer<@NonNull String> unknownAction = null;

    public CmdLineProcessor(String cmd, @Nullable String[] args) {
        this(cmd, Arrays.asList(args));
    }

    public CmdLineProcessor(String cmd, Iterable<@Nullable String> args) {
        this.cmd = cmd;
        this.args = args;
    }

    public static boolean isActionArg(String arg) {
        return ACTION_ARG_PATTERN.matcher(arg).matches();
    }

    public void process() throws CmdLineException {
        ProcessingContext context = new ProcessingContext();
        for (String arg : this.args) {
            Consumer<String> defaultAction;
            if (arg == null || context.processPendingOptionAction(arg) || context.processOptionAction(arg, this.optionActions) || context.processSwitchAction(arg, this.switchActions)) continue;
            Consumer<String> consumer = defaultAction = CmdLineProcessor.isActionArg(arg) ? this.unknownAction : this.unnamedAction;
            if (defaultAction != null) {
                try {
                    defaultAction.accept(arg);
                    continue;
                }
                catch (RuntimeException e) {
                    throw new CmdLineException(this, arg, e);
                }
            }
            throw new CmdLineException(this, arg);
        }
        context.verifyNoPendingOptionAction();
    }

    public CmdLineAction onSwitch(Consumer<@NonNull String> action) {
        SwitchCmdLineAction switchAction = new SwitchCmdLineAction(action);
        this.switchActions.add(switchAction);
        return switchAction;
    }

    public CmdLineAction onOption(BiConsumer<@NonNull String, @NonNull String> action) {
        OptionCmdLineAction optionAction = new OptionCmdLineAction(action);
        this.optionActions.add(optionAction);
        return optionAction;
    }

    public void onUnnamedOption(Consumer<@NonNull String> action) {
        this.unnamedAction = action;
    }

    public void onUnknownArg(Consumer<@NonNull String> action) {
        this.unknownAction = action;
    }

    public static void ignore(String arg) {
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.cmd);
        for (String arg : this.args) {
            buffer.append(" ");
            buffer.append(arg);
        }
        return buffer.toString();
    }

    private class OptionCmdLineAction
    extends CmdLineAction
    implements BiConsumer<String, String> {
        private final BiConsumer<@NonNull String, @NonNull String> action;

        OptionCmdLineAction(BiConsumer<String, String> action) {
            this.action = action;
        }

        @Override
        public void accept(String t, String u) {
            this.action.accept(t, u);
        }
    }

    private class SwitchCmdLineAction
    extends CmdLineAction
    implements Consumer<String> {
        private final Consumer<@NonNull String> action;

        SwitchCmdLineAction(Consumer<String> action) {
            this.action = action;
        }

        @Override
        public void accept(String t) {
            this.action.accept(t);
        }
    }

    private class ProcessingContext {
        private @Nullable OptionCmdLineAction pendingOptionAction = null;
        private @Nullable String pendingArg = null;

        ProcessingContext() {
        }

        public boolean processPendingOptionAction(String option) throws CmdLineException {
            OptionCmdLineAction optionAction = this.pendingOptionAction;
            String arg = this.pendingArg;
            boolean processed = false;
            if (optionAction != null && arg != null) {
                if (CmdLineProcessor.isActionArg(option)) {
                    throw new CmdLineException(CmdLineProcessor.this, arg);
                }
                try {
                    optionAction.accept(arg, option);
                }
                catch (RuntimeException e) {
                    throw new CmdLineException(CmdLineProcessor.this, arg, e);
                }
                this.pendingOptionAction = null;
                this.pendingArg = null;
                processed = true;
            }
            return processed;
        }

        public void verifyNoPendingOptionAction() throws CmdLineException {
            OptionCmdLineAction optionAction = this.pendingOptionAction;
            String arg = this.pendingArg;
            if (optionAction != null && arg != null) {
                throw new CmdLineException(CmdLineProcessor.this, arg);
            }
        }

        public boolean processOptionAction(String arg, List<OptionCmdLineAction> actions) {
            Optional<OptionCmdLineAction> optOptionAction = actions.stream().filter(action -> action.contains(arg)).findFirst();
            boolean processed = false;
            if (optOptionAction.isPresent()) {
                this.pendingOptionAction = optOptionAction.get();
                this.pendingArg = arg;
                processed = true;
            }
            return processed;
        }

        public boolean processSwitchAction(String arg, List<SwitchCmdLineAction> actions) throws CmdLineException {
            Optional<SwitchCmdLineAction> optSwitchAction = actions.stream().filter(action -> action.contains(arg)).findFirst();
            boolean processed = false;
            if (optSwitchAction.isPresent()) {
                try {
                    optSwitchAction.get().accept(arg);
                }
                catch (RuntimeException e) {
                    throw new CmdLineException(CmdLineProcessor.this, arg, e);
                }
                processed = true;
            }
            return processed;
        }
    }
}

